/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.embracesdk;

import android.app.Application;
import android.content.Context;
import android.util.Pair;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.fernandocejas.arrow.checks.Preconditions;
import io.embrace.android.embracesdk.ActivityService;
import io.embrace.android.embracesdk.AnrService;
import io.embrace.android.embracesdk.ApiClient;
import io.embrace.android.embracesdk.BreadcrumbService;
import io.embrace.android.embracesdk.BuildInfo;
import io.embrace.android.embracesdk.CacheService;
import io.embrace.android.embracesdk.Clock;
import io.embrace.android.embracesdk.ConfigService;
import io.embrace.android.embracesdk.ConnectionQualityListener;
import io.embrace.android.embracesdk.CpuService;
import io.embrace.android.embracesdk.CrashService;
import io.embrace.android.embracesdk.EmbraceActivityService;
import io.embrace.android.embracesdk.EmbraceAnrService;
import io.embrace.android.embracesdk.EmbraceBreadcrumbService;
import io.embrace.android.embracesdk.EmbraceCacheService;
import io.embrace.android.embracesdk.EmbraceConfigService;
import io.embrace.android.embracesdk.EmbraceConnectionClassService;
import io.embrace.android.embracesdk.EmbraceCpuService;
import io.embrace.android.embracesdk.EmbraceCrashService;
import io.embrace.android.embracesdk.EmbraceEvent;
import io.embrace.android.embracesdk.EmbraceEventService;
import io.embrace.android.embracesdk.EmbraceExceptionService;
import io.embrace.android.embracesdk.EmbraceLogger;
import io.embrace.android.embracesdk.EmbraceMemoryCleanerService;
import io.embrace.android.embracesdk.EmbraceMemoryService;
import io.embrace.android.embracesdk.EmbraceMetadataService;
import io.embrace.android.embracesdk.EmbraceNdkService;
import io.embrace.android.embracesdk.EmbraceNetworkConnectivityService;
import io.embrace.android.embracesdk.EmbraceNetworkLoggingService;
import io.embrace.android.embracesdk.EmbraceOrientationService;
import io.embrace.android.embracesdk.EmbracePerformanceInfoService;
import io.embrace.android.embracesdk.EmbracePowerService;
import io.embrace.android.embracesdk.EmbracePreferencesService;
import io.embrace.android.embracesdk.EmbraceRemoteLogger;
import io.embrace.android.embracesdk.EmbraceScreenshotService;
import io.embrace.android.embracesdk.EmbraceSessionProperties;
import io.embrace.android.embracesdk.EmbraceSessionService;
import io.embrace.android.embracesdk.EmbraceSignalQualityService;
import io.embrace.android.embracesdk.EmbraceUserService;
import io.embrace.android.embracesdk.EventService;
import io.embrace.android.embracesdk.JsException;
import io.embrace.android.embracesdk.LocalConfig;
import io.embrace.android.embracesdk.MemoryCleanerService;
import io.embrace.android.embracesdk.MemoryService;
import io.embrace.android.embracesdk.MessageType;
import io.embrace.android.embracesdk.MetadataService;
import io.embrace.android.embracesdk.NdkService;
import io.embrace.android.embracesdk.NetworkConnectivityService;
import io.embrace.android.embracesdk.NetworkLoggingService;
import io.embrace.android.embracesdk.OrientationService;
import io.embrace.android.embracesdk.PerformanceInfoService;
import io.embrace.android.embracesdk.PowerService;
import io.embrace.android.embracesdk.PreferencesService;
import io.embrace.android.embracesdk.PropertyUtils;
import io.embrace.android.embracesdk.ScreenshotService;
import io.embrace.android.embracesdk.Session;
import io.embrace.android.embracesdk.SignalQualityService;
import io.embrace.android.embracesdk.StreamHandlerFactoryInstaller;
import io.embrace.android.embracesdk.SystemClock;
import io.embrace.android.embracesdk.TapBreadcrumb;
import io.embrace.android.embracesdk.UserService;
import io.embrace.android.embracesdk.network.EmbraceNetworkRequest;
import io.embrace.android.embracesdk.network.http.HttpMethod;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;

public final class Embrace {
    private static Embrace embrace = new Embrace();
    private static final String ERROR_NOT_INITIALIZED = "Embrace SDK is not initialized yet, cannot log event";
    private static final String ERROR_USER_UPDATES_DISABLED = "User updates are disabled, ignoring user persona update.";
    private volatile Application application;
    private volatile Clock clock;
    private volatile CacheService cacheService;
    private volatile CrashService crashService;
    private volatile BreadcrumbService breadcrumbService;
    private volatile EmbraceSessionService sessionService;
    private volatile MetadataService metadataService;
    private volatile PerformanceInfoService performanceInfoService;
    private volatile PowerService powerService;
    private volatile MemoryService memoryService;
    private volatile EmbraceActivityService activityService;
    private volatile NetworkConnectivityService networkConnectivityService;
    private volatile NetworkLoggingService networkLoggingService;
    private volatile CpuService cpuService;
    private volatile BuildInfo buildInfo;
    private volatile LocalConfig localConfig;
    private volatile AnrService anrService;
    private volatile EmbraceRemoteLogger remoteLogger;
    private volatile ConfigService configService;
    private volatile PreferencesService preferencesService;
    private volatile ScreenshotService screenshotService;
    private volatile EventService eventService;
    private volatile UserService userService;
    private volatile SignalQualityService signalQualityService;
    private volatile EmbraceExceptionService exceptionsService;
    private volatile MemoryCleanerService memoryCleanerService;
    private volatile OrientationService orientationService;
    private volatile NdkService ndkService;
    private final AtomicBoolean started = new AtomicBoolean(false);

    @NonNull
    public static Embrace getInstance() {
        return embrace;
    }

    static void setInstance(@Nullable Embrace instance) {
        embrace = instance;
    }

    public void start(@NonNull Context context) {
        this.start(context, true, AppFramework.NATIVE);
    }

    public void start(@NonNull Context context, boolean enableIntegrationTesting) {
        this.start(context, enableIntegrationTesting, AppFramework.NATIVE);
    }

    public void start(@NonNull Context context, boolean enableIntegrationTesting, @NonNull AppFramework appFramework) {
        if (this.application != null) {
            EmbraceLogger.logWarning("Embrace SDK has already been initialized");
            return;
        }
        if (!(context instanceof Application)) {
            context = context.getApplicationContext();
        }
        this.application = (Application)Preconditions.checkNotNull((Object)((Application)context), (Object)"application must not be null");
        try {
            this.clock = new SystemClock();
            this.memoryCleanerService = new EmbraceMemoryCleanerService();
            this.powerService = new EmbracePowerService(context, this.memoryCleanerService);
            this.memoryService = EmbraceMemoryService.ofContext(context, this.memoryCleanerService);
            this.orientationService = new EmbraceOrientationService(this.memoryCleanerService);
            this.activityService = new EmbraceActivityService(this.application, this.memoryService, this.orientationService);
            this.exceptionsService = new EmbraceExceptionService(this.activityService);
            this.preferencesService = new EmbracePreferencesService(context, this.activityService);
            this.networkConnectivityService = new EmbraceNetworkConnectivityService(context, this.clock, this.memoryCleanerService);
            this.cpuService = new EmbraceCpuService();
            this.buildInfo = BuildInfo.fromResources(context);
            this.localConfig = LocalConfig.fromResources(context);
            this.metadataService = EmbraceMetadataService.ofContext(context, this.buildInfo, this.localConfig, appFramework, this.preferencesService, this.activityService);
            EmbraceConnectionClassService connectionClassService = new EmbraceConnectionClassService(this.memoryCleanerService);
            EmbraceSessionProperties sessionProperties = new EmbraceSessionProperties(this.preferencesService);
            this.cacheService = new EmbraceCacheService(context);
            ApiClient apiClient = new ApiClient(this.localConfig, this.metadataService, this.cacheService, enableIntegrationTesting);
            this.configService = new EmbraceConfigService(apiClient, this.activityService, this.cacheService, this.metadataService);
            this.anrService = new EmbraceAnrService(this.clock, this.memoryCleanerService, this.configService, this.activityService);
            this.exceptionsService.setConfigService(this.configService);
            this.signalQualityService = new EmbraceSignalQualityService(context, this.configService, this.activityService, connectionClassService, this.memoryCleanerService);
            this.breadcrumbService = new EmbraceBreadcrumbService(this.clock, this.configService, this.localConfig, this.activityService, this.memoryCleanerService);
            if (this.configService.isSdkDisabled()) {
                this.stop();
                return;
            }
            this.userService = new EmbraceUserService(this.preferencesService);
            this.screenshotService = new EmbraceScreenshotService(this.activityService, this.configService, apiClient);
            this.networkLoggingService = new EmbraceNetworkLoggingService(connectionClassService, this.configService, this.localConfig, this.memoryCleanerService);
            this.performanceInfoService = new EmbracePerformanceInfoService(this.anrService, this.networkConnectivityService, this.networkLoggingService, this.powerService, this.cpuService, this.memoryService, this.signalQualityService, connectionClassService, this.metadataService);
            this.eventService = new EmbraceEventService(apiClient, this.configService, this.localConfig, this.metadataService, this.performanceInfoService, this.userService, this.screenshotService, this.activityService, this.memoryCleanerService, sessionProperties);
            this.remoteLogger = new EmbraceRemoteLogger(this.metadataService, this.screenshotService, apiClient, this.userService, this.configService, this.memoryCleanerService, sessionProperties);
            this.ndkService = new EmbraceNdkService(context, this.metadataService, this.activityService, this.localConfig, apiClient, this.userService, sessionProperties, appFramework);
            this.sessionService = new EmbraceSessionService(this.preferencesService, this.performanceInfoService, this.metadataService, this.networkConnectivityService, this.breadcrumbService, this.powerService, this.activityService, apiClient, this.eventService, this.remoteLogger, this.userService, this.configService, this.cacheService, this.exceptionsService, this.localConfig, this.memoryCleanerService, this.orientationService, this.ndkService, sessionProperties);
            this.crashService = new EmbraceCrashService(this.localConfig, this.sessionService, this.metadataService, apiClient, this.userService, this.eventService, this.ndkService);
        }
        catch (Exception ex) {
            EmbraceLogger.logError("Exception occurred while initializing the Embrace SDK. Instrumentation may be disabled.", ex, true);
            if (enableIntegrationTesting) {
                throw ex;
            }
            return;
        }
        EmbraceLogger.logInfo(String.format("Embrace SDK started. App ID: %s Version: %s", this.localConfig.getAppId(), "4.6.0"));
        StreamHandlerFactoryInstaller.registerFactory(this.localConfig.getConfigurations().getNetworking().getCaptureRequestContentLength());
        this.started.set(true);
    }

    public boolean isStarted() {
        return this.started.get();
    }

    void stop() {
        this.stop(false);
    }

    void stop(Boolean hard) {
        if (this.started.compareAndSet(true, false)) {
            EmbraceLogger.logInfo("Shutting down Embrace SDK.");
            try {
                if (this.anrService != null) {
                    this.anrService.close();
                }
                if (this.powerService != null) {
                    this.powerService.close();
                }
                if (this.memoryService != null) {
                    this.memoryService.close();
                }
                if (this.cpuService != null) {
                    this.cpuService.close();
                }
                if (this.anrService != null) {
                    this.anrService.close();
                }
                if (this.activityService != null) {
                    this.activityService.close();
                }
                if (this.sessionService != null) {
                    this.sessionService.close();
                }
                if (this.eventService != null) {
                    this.eventService.close();
                }
                if (this.networkConnectivityService != null) {
                    this.networkConnectivityService.close();
                }
                if (this.signalQualityService != null) {
                    this.signalQualityService.close();
                }
                this.memoryCleanerService = null;
                this.powerService = null;
                this.memoryService = null;
                this.breadcrumbService = null;
                this.activityService = null;
                this.preferencesService = null;
                this.networkConnectivityService = null;
                this.cpuService = null;
                this.anrService = null;
                this.buildInfo = null;
                this.localConfig = null;
                this.metadataService = null;
                this.performanceInfoService = null;
                this.cacheService = null;
                this.userService = null;
                this.screenshotService = null;
                this.eventService = null;
                this.remoteLogger = null;
                this.sessionService = null;
                this.crashService = null;
                this.signalQualityService = null;
                this.networkLoggingService = null;
                if (hard.booleanValue()) {
                    if (this.configService != null) {
                        this.configService.close();
                    }
                    this.configService = null;
                }
                this.application = null;
            }
            catch (Exception ex) {
                EmbraceLogger.logDebug("Error while shutting down Embrace SDK", ex);
            }
        }
    }

    @Deprecated
    public void setLogLevel(@NonNull EmbraceLogger.Severity severity) {
    }

    public void enableDebugLogging() {
        EmbraceLogger.setThreshold(EmbraceLogger.Severity.DEBUG);
    }

    public void disableDebugLogging() {
        EmbraceLogger.setThreshold(EmbraceLogger.Severity.INFO);
    }

    public void setUserIdentifier(@Nullable String userId) {
        if (this.isStarted()) {
            if (this.configService.isMessageTypeDisabled(MessageType.USER)) {
                EmbraceLogger.logWarning("User updates are disabled, ignoring identifier update.");
                return;
            }
            this.userService.setUserIdentifier(userId);
            this.ndkService.onUserInfoUpdate();
            if (userId != null) {
                EmbraceLogger.logDebug("Set user ID to " + userId);
            } else {
                EmbraceLogger.logDebug("Cleared user ID by setting to null");
            }
        } else {
            EmbraceLogger.logWarning("Embrace SDK is not initialized yet, cannot set user identifier");
        }
    }

    public void clearUserIdentifier() {
        if (this.isStarted()) {
            if (this.configService.isMessageTypeDisabled(MessageType.USER)) {
                EmbraceLogger.logWarning("User updates are disabled, ignoring identifier update.");
                return;
            }
            this.userService.clearUserIdentifier();
            EmbraceLogger.logDebug("Cleared user ID");
        }
    }

    public void setUserEmail(@Nullable String email) {
        if (this.isStarted()) {
            if (this.configService.isMessageTypeDisabled(MessageType.USER)) {
                EmbraceLogger.logWarning("User updates are disabled, ignoring email update.");
                return;
            }
            this.userService.setUserEmail(email);
            this.ndkService.onUserInfoUpdate();
            if (email != null) {
                EmbraceLogger.logDebug("Set email to " + email);
            } else {
                EmbraceLogger.logDebug("Cleared email by setting to null");
            }
        } else {
            EmbraceLogger.logWarning("Embrace SDK is not initialized yet, cannot clear user identifier");
        }
    }

    public void clearUserEmail() {
        if (this.isStarted()) {
            if (this.configService.isMessageTypeDisabled(MessageType.USER)) {
                EmbraceLogger.logWarning("User updates are disabled, ignoring email update.");
                return;
            }
            this.userService.clearUserEmail();
            this.ndkService.onUserInfoUpdate();
            EmbraceLogger.logDebug("Cleared email");
        } else {
            EmbraceLogger.logWarning("Embrace SDK is not initialized yet, cannot clear user email");
        }
    }

    public void setUserAsPayer() {
        if (this.isStarted()) {
            if (this.configService.isMessageTypeDisabled(MessageType.USER)) {
                EmbraceLogger.logWarning("User updates are disabled, ignoring payer user update.");
                return;
            }
            this.userService.setUserAsPayer();
            this.ndkService.onUserInfoUpdate();
        } else {
            EmbraceLogger.logWarning("Embrace SDK is not initialized yet, cannot set user as payer");
        }
    }

    public void clearUserAsPayer() {
        if (this.isStarted()) {
            if (this.configService.isMessageTypeDisabled(MessageType.USER)) {
                EmbraceLogger.logWarning("User updates are disabled, ignoring payer user update.");
                return;
            }
            this.userService.clearUserAsPayer();
            this.ndkService.onUserInfoUpdate();
        } else {
            EmbraceLogger.logWarning("Embrace SDK is not initialized yet, cannot clear user as payer");
        }
    }

    public void setUserPersona(@NonNull String persona) {
        if (this.isStarted()) {
            if (this.configService.isMessageTypeDisabled(MessageType.USER)) {
                EmbraceLogger.logWarning(ERROR_USER_UPDATES_DISABLED);
                return;
            }
            this.userService.setUserPersona(persona);
            this.ndkService.onUserInfoUpdate();
        } else {
            EmbraceLogger.logWarning("Embrace SDK is not initialized yet, cannot set user persona");
        }
    }

    public void clearUserPersona(@NonNull String persona) {
        if (this.isStarted()) {
            if (this.configService.isMessageTypeDisabled(MessageType.USER)) {
                EmbraceLogger.logWarning(ERROR_USER_UPDATES_DISABLED);
                return;
            }
            this.userService.clearUserPersona(persona);
            this.ndkService.onUserInfoUpdate();
        } else {
            EmbraceLogger.logWarning("Embrace SDK is not initialized yet, cannot clear user persona");
        }
    }

    public void clearAllUserPersonas() {
        if (this.isStarted()) {
            if (this.configService.isMessageTypeDisabled(MessageType.USER)) {
                EmbraceLogger.logWarning(ERROR_USER_UPDATES_DISABLED);
                return;
            }
            this.userService.clearAllUserPersonas();
            this.ndkService.onUserInfoUpdate();
        } else {
            EmbraceLogger.logWarning("Embrace SDK is not initialized yet, cannot clear user personas");
        }
    }

    public boolean addSessionProperty(@NonNull String key, @NonNull String value, boolean permanent) {
        if (this.isStarted()) {
            return this.sessionService.addProperty(key, value, permanent);
        }
        EmbraceLogger.logWarning("Embrace SDK is not initialized yet, cannot add session property");
        return false;
    }

    public boolean removeSessionProperty(@NonNull String key) {
        if (this.isStarted()) {
            return this.sessionService.removeProperty(key);
        }
        EmbraceLogger.logWarning("Embrace SDK is not initialized yet, cannot remove session property");
        return false;
    }

    @Nullable
    public Map<String, String> getSessionProperties() {
        if (this.isStarted()) {
            return this.sessionService.getProperties();
        }
        EmbraceLogger.logWarning("Embrace SDK is not initialized yet, cannot gets session properties");
        return null;
    }

    public void setUsername(@Nullable String username) {
        if (this.isStarted()) {
            if (this.configService.isMessageTypeDisabled(MessageType.USER)) {
                EmbraceLogger.logWarning("User updates are disabled, ignoring username update.");
                return;
            }
            this.userService.setUsername(username);
            this.ndkService.onUserInfoUpdate();
            if (username != null) {
                EmbraceLogger.logDebug("Set username to " + username);
            } else {
                EmbraceLogger.logDebug("Cleared username by setting to null");
            }
        } else {
            EmbraceLogger.logWarning("Embrace SDK is not initialized yet, cannot set username");
        }
    }

    public void clearUsername() {
        if (this.isStarted()) {
            if (this.configService.isMessageTypeDisabled(MessageType.USER)) {
                EmbraceLogger.logWarning("User updates are disabled, ignoring username update.");
                return;
            }
            this.userService.clearUsername();
            this.ndkService.onUserInfoUpdate();
            EmbraceLogger.logDebug("Cleared username");
        } else {
            EmbraceLogger.logWarning("Embrace SDK is not initialized yet, cannot clear username");
        }
    }

    public void startEvent(@NonNull String name) {
        if (this.isStarted()) {
            this.eventService.startEvent(name);
        } else {
            EmbraceLogger.logWarning(ERROR_NOT_INITIALIZED);
        }
    }

    public void startEvent(@NonNull String name, @Nullable String identifier) {
        if (this.isStarted()) {
            this.eventService.startEvent(name, identifier);
        }
    }

    public void startEvent(@NonNull String name, @Nullable String identifier, boolean allowScreenshot) {
        if (this.isStarted()) {
            this.eventService.startEvent(name, identifier, allowScreenshot);
        } else {
            EmbraceLogger.logWarning(ERROR_NOT_INITIALIZED);
        }
    }

    public void startEvent(@NonNull String name, @Nullable String identifier, @Nullable Map<String, Object> properties) {
        if (this.isStarted()) {
            this.eventService.startEvent(name, identifier, this.normalizeProperties(properties));
        } else {
            EmbraceLogger.logWarning(ERROR_NOT_INITIALIZED);
        }
    }

    public void startEvent(@NonNull String name, @Nullable String identifier, boolean allowScreenshot, @Nullable Map<String, Object> properties) {
        if (this.isStarted()) {
            this.eventService.startEvent(name, identifier, allowScreenshot, this.normalizeProperties(properties));
        } else {
            EmbraceLogger.logWarning(ERROR_NOT_INITIALIZED);
        }
    }

    public void endEvent(@NonNull String name) {
        if (this.isStarted()) {
            this.eventService.endEvent(name);
        } else {
            EmbraceLogger.logWarning(ERROR_NOT_INITIALIZED);
        }
    }

    public void endEvent(@NonNull String name, @Nullable String identifier) {
        if (this.isStarted()) {
            this.eventService.endEvent(name, identifier);
        } else {
            EmbraceLogger.logWarning(ERROR_NOT_INITIALIZED);
        }
    }

    public void endEvent(@NonNull String name, @Nullable Map<String, Object> properties) {
        if (this.isStarted()) {
            this.eventService.endEvent(name, this.normalizeProperties(properties));
        } else {
            EmbraceLogger.logWarning(ERROR_NOT_INITIALIZED);
        }
    }

    public void endEvent(@NonNull String name, @Nullable String identifier, @Nullable Map<String, Object> properties) {
        if (this.isStarted()) {
            this.eventService.endEvent(name, identifier, this.normalizeProperties(properties));
        } else {
            EmbraceLogger.logWarning(ERROR_NOT_INITIALIZED);
        }
    }

    public void endAppStartup() {
        this.endEvent("_startup");
    }

    public void endAppStartup(@NonNull Map<String, Object> properties) {
        this.endEvent("_startup", null, properties);
    }

    public String getTraceIdHeader() {
        return this.isStarted() ? this.localConfig.getConfigurations().getNetworking().getTraceIdHeader() : "x-emb-trace-id";
    }

    public void logNetworkRequest(@NonNull EmbraceNetworkRequest request) {
        if (this.isStarted()) {
            if (request == null) {
                return;
            }
            if (!request.canSend()) {
                return;
            }
            if (request.getError() != null) {
                this.networkLoggingService.logNetworkError(request.getUrl(), request.getHttpMethod(), request.getStartTime(), request.getEndTime(), request.getError().getClass().getCanonicalName(), request.getError().getLocalizedMessage(), request.getTraceId());
            } else {
                this.networkLoggingService.logNetworkCall(request.getUrl(), request.getHttpMethod(), request.getResponseCode(), request.getStartTime(), request.getEndTime(), request.getBytesIn(), request.getBytesOut(), request.getTraceId());
            }
        } else {
            EmbraceLogger.logWarning("Embrace SDK is not initialized yet, cannot log network request");
        }
    }

    public void logNetworkCall(@NonNull String url, @NonNull HttpMethod httpMethod, int statusCode, long startTime, long endTime, long bytesSent, long bytesReceived) {
        this.logNetworkCall(url, httpMethod, statusCode, startTime, endTime, bytesSent, bytesReceived, null);
    }

    public void logNetworkCall(@NonNull String url, @NonNull HttpMethod httpMethod, int statusCode, long startTime, long endTime, long bytesSent, long bytesReceived, @Nullable String traceId) {
        if (this.isStarted()) {
            if (this.configService.isUrlDisabled(url) || this.localConfig.isUrlDisabled(url)) {
                EmbraceLogger.logWarning("Recording of network calls disabled for url: " + url);
                return;
            }
            this.networkLoggingService.logNetworkCall(url, httpMethod.name(), statusCode, startTime, endTime, bytesSent, bytesReceived, traceId);
        } else {
            EmbraceLogger.logWarning("Embrace SDK is not initialized yet, cannot log network call");
        }
    }

    public void logNetworkClientError(@NonNull String url, @NonNull HttpMethod httpMethod, long startTime, long endTime, String errorType, String errorMessage) {
        this.logNetworkClientError(url, httpMethod, startTime, endTime, errorType, errorMessage, null);
    }

    public void logNetworkClientError(@NonNull String url, @NonNull HttpMethod httpMethod, long startTime, long endTime, String errorType, String errorMessage, @Nullable String traceId) {
        if (this.isStarted()) {
            if (this.configService.isUrlDisabled(url) || this.localConfig.isUrlDisabled(url)) {
                EmbraceLogger.logWarning("Recording of network calls disabled for url: " + url);
                return;
            }
            this.networkLoggingService.logNetworkError(url, httpMethod.name(), startTime, endTime, errorType, errorMessage, traceId);
        } else {
            EmbraceLogger.logDebug("Embrace SDK is not initialized yet, cannot log network error");
        }
    }

    public void logInfo(@NonNull String message) {
        this.logInfo(message, null);
    }

    public void logInfo(@NonNull String message, @Nullable Map<String, Object> properties) {
        this.logMessage(EmbraceEvent.Type.INFO_LOG, message, properties, false, null, null, false);
    }

    public void logWarning(@NonNull String message) {
        this.logWarning(message, null, false, null);
    }

    public void logWarning(@NonNull String message, @Nullable Map<String, Object> properties) {
        this.logWarning(message, properties, false, null);
    }

    public void logWarning(@NonNull String message, @Nullable Map<String, Object> properties, boolean allowScreenshot) {
        this.logWarning(message, properties, allowScreenshot, null);
    }

    public void logWarning(@NonNull String message, @Nullable Map<String, Object> properties, boolean allowScreenshot, @Nullable String javascriptStackTrace) {
        this.logMessage(EmbraceEvent.Type.WARNING_LOG, message, properties, allowScreenshot, null, javascriptStackTrace, false);
    }

    public void logError(@NonNull String message) {
        this.logError(message, null, true, null);
    }

    public void logError(@NonNull String message, @Nullable Map<String, Object> properties) {
        this.logError(message, properties, true, null);
    }

    public void logError(@NonNull String message, @Nullable Map<String, Object> properties, boolean allowScreenshot) {
        this.logError(message, properties, allowScreenshot, null);
    }

    public void logError(@NonNull String message, @Nullable Map<String, Object> properties, boolean allowScreenshot, @Nullable String javascriptStackTrace) {
        this.logMessage(EmbraceEvent.Type.ERROR_LOG, message, properties, allowScreenshot, null, javascriptStackTrace, false);
    }

    public void logError(@NonNull String message, @Nullable Map<String, Object> properties, boolean allowScreenshot, @Nullable String javascriptStackTrace, boolean isException) {
        this.logMessage(EmbraceEvent.Type.ERROR_LOG, message, properties, allowScreenshot, null, javascriptStackTrace, isException);
    }

    public void logError(@NonNull Throwable e) {
        this.logError(e, null, false);
    }

    public void logError(@NonNull Throwable e, @Nullable Map<String, Object> properties) {
        this.logError(e, properties, false);
    }

    public void logError(@NonNull Throwable e, @Nullable Map<String, Object> properties, boolean allowScreenshot) {
        this.logError(e, e.getLocalizedMessage(), properties, allowScreenshot);
    }

    public void logError(@NonNull Throwable e, String message, @Nullable Map<String, Object> properties, boolean allowScreenshot) {
        this.logMessage(EmbraceEvent.Type.ERROR_LOG, message, properties, allowScreenshot, e.getStackTrace(), null, true);
    }

    void logMessage(EmbraceEvent.Type type, String message, Map<String, Object> properties, boolean allowScreenshot, StackTraceElement[] stackTraceElements, String javascriptStackTrace, boolean isException) {
        if (this.isStarted()) {
            try {
                this.remoteLogger.log(message, type, allowScreenshot, isException, this.normalizeProperties(properties), stackTraceElements, javascriptStackTrace);
            }
            catch (Exception ex) {
                EmbraceLogger.logDebug("Failed to log message using Embrace SDK.", ex);
            }
        } else {
            EmbraceLogger.logWarning("Embrace SDK is not initialized yet, cannot log message.");
        }
    }

    public void logBreadcrumb(@NonNull String message) {
        if (this.isStarted()) {
            this.breadcrumbService.logCustom(message, System.currentTimeMillis());
        } else {
            EmbraceLogger.logWarning("Embrace SDK is not initialized yet, cannot log breadcrumb.");
        }
    }

    public void logUnhandledJsException(String name, String message, String type, String stacktrace) {
        if (this.isStarted()) {
            JsException exception = new JsException(name, message, type, stacktrace);
            this.crashService.logUnhandledJsException(exception);
        } else {
            EmbraceLogger.logWarning("Embrace SDK is not initialized yet, cannot log JS exception.");
        }
    }

    public void setReactNativeVersionNumber(@NonNull String version) {
        if (this.isStarted()) {
            if (version == null) {
                EmbraceLogger.logError("ReactNative version must not be null");
                return;
            }
            if (version.isEmpty()) {
                EmbraceLogger.logError("ReactNative version must have non-zero length");
                return;
            }
            this.preferencesService.setReactNativeVersionNumber(version);
        } else {
            EmbraceLogger.logError("Embrace SDK is not initialized yet, cannot set React Native version number.");
        }
    }

    public void setJavaScriptPatchNumber(@NonNull String number) {
        if (this.isStarted()) {
            if (number == null) {
                EmbraceLogger.logError("JavaScript patch number must not be null");
                return;
            }
            if (number.isEmpty()) {
                EmbraceLogger.logError("JavaScript patch number must have non-zero length");
                return;
            }
            this.preferencesService.setJavaScriptPatchNumber(number);
        } else {
            EmbraceLogger.logError("Embrace SDK is not initialized yet, cannot set JavaScript patch number.");
        }
    }

    public void setJavaScriptBundleURL(@NonNull String url) {
        if (this.isStarted()) {
            String currentUrl;
            if (url == null) {
                EmbraceLogger.logError("JavaScript bundle URL must not be null");
                return;
            }
            if (url.isEmpty()) {
                EmbraceLogger.logError("JavaScript bundle URL must have non-zero length");
                return;
            }
            if (this.preferencesService.getJavaScriptBundleURL().isPresent() && url.equals(currentUrl = (String)this.preferencesService.getJavaScriptBundleURL().get())) {
                return;
            }
            this.preferencesService.setJavaScriptBundleURL(url);
        } else {
            EmbraceLogger.logError("Embrace SDK is not initialized yet, cannot set JavaScript bundle URL.");
        }
    }

    public void setUnityMetaData(String unityVersion, String buildGUID) {
        if (this.isStarted()) {
            if (unityVersion == null || buildGUID == null) {
                EmbraceLogger.logError(String.format("Unity metadata is corrupted or malformed. Unity version is %s and Unity build id is %s", unityVersion, buildGUID));
                return;
            }
            if (this.preferencesService.getUnityVersionNumber().isPresent()) {
                String currentUnityVersion = (String)this.preferencesService.getUnityVersionNumber().get();
                if (!unityVersion.equals(currentUnityVersion)) {
                    this.preferencesService.setUnityVersionNumber(unityVersion);
                }
            } else {
                this.preferencesService.setUnityVersionNumber(unityVersion);
            }
            if (this.preferencesService.getUnityBuildIdNumber().isPresent()) {
                String currentUnityBuildId = (String)this.preferencesService.getUnityBuildIdNumber().get();
                if (!buildGUID.equals(currentUnityBuildId)) {
                    this.preferencesService.setUnityBuildIdNumber(buildGUID);
                }
            } else {
                this.preferencesService.setUnityBuildIdNumber(buildGUID);
            }
        } else {
            EmbraceLogger.logError("Embrace SDK is not initialized yet, cannot set Unity metadata.");
        }
    }

    public void addConnectionQualityListener(@NonNull ConnectionQualityListener listener) {
        if (this.isStarted()) {
            try {
                this.signalQualityService.addListener(listener);
            }
            catch (Exception ex) {
                EmbraceLogger.logDebug("Failed to add connection quality listener", ex);
            }
        } else {
            EmbraceLogger.logDebug("Embrace SDK is not initialized yet, cannot add listener.");
        }
    }

    public void removeConnectionQualityListener(@NonNull ConnectionQualityListener listener) {
        if (this.isStarted()) {
            try {
                this.signalQualityService.removeListener(listener);
            }
            catch (Exception ex) {
                EmbraceLogger.logDebug("Failed to remove connection quality listener", ex);
            }
        } else {
            EmbraceLogger.logWarning("Embrace SDK is not initialized yet, cannot remove listener.");
        }
    }

    public synchronized void endSession() {
        this.endSession(false);
    }

    public synchronized void endSession(boolean clearUserInfo) {
        if (this.isStarted()) {
            if (this.localConfig.getConfigurations().getSessionConfig().getMaxSessionSeconds().isPresent()) {
                EmbraceLogger.logWarning("Can't close the session, automatic session close enabled.");
                return;
            }
            if (this.localConfig.getConfigurations().getSessionConfig().getAsyncEnd().booleanValue() || this.configService.getConfig().endSessionInBackgroundThread().booleanValue()) {
                EmbraceLogger.logWarning("Can't close the session, session ending in background thread enabled.");
                return;
            }
            if (clearUserInfo) {
                this.userService.clearAllUserInfo();
                this.ndkService.onUserInfoUpdate();
            }
            this.sessionService.triggerStatelessSessionEnd(Session.SessionLifeEventType.MANUAL);
        } else {
            EmbraceLogger.logWarning("Embrace SDK is not initialized yet, cannot end session.");
        }
    }

    public String getDeviceId() {
        return (String)this.preferencesService.getDeviceIdentifier().orNull();
    }

    public void throwException() {
        throw new RuntimeException("EmbraceException", new Throwable("Embrace test exception"));
    }

    public boolean startFragment(@NonNull String name) {
        if (this.isStarted()) {
            return this.breadcrumbService.startFragment(name);
        }
        return false;
    }

    public boolean endFragment(@NonNull String name) {
        if (this.isStarted()) {
            return this.breadcrumbService.endFragment(name);
        }
        return false;
    }

    void logView(String screen) {
        if (this.isStarted()) {
            this.breadcrumbService.logView(screen, System.currentTimeMillis());
        }
    }

    void logWebView(String url) {
        if (this.isStarted()) {
            this.breadcrumbService.logWebView(url, System.currentTimeMillis());
        }
    }

    void forceLogView(String screen) {
        if (this.isStarted()) {
            this.breadcrumbService.forceLogView(screen, System.currentTimeMillis());
        }
    }

    void logTap(Pair<Float, Float> point, String elementName, TapBreadcrumb.TapBreadcrumbType type) {
        if (this.isStarted()) {
            this.breadcrumbService.logTap(point, elementName, System.currentTimeMillis(), type);
        }
    }

    LocalConfig getLocalConfig() {
        return this.localConfig;
    }

    EventService getEventService() {
        return this.eventService;
    }

    ActivityService getActivityService() {
        return this.activityService;
    }

    EmbraceRemoteLogger getRemoteLogger() {
        return this.remoteLogger;
    }

    EmbraceExceptionService getExceptionsService() {
        return this.exceptionsService;
    }

    MetadataService getMetadataService() {
        return this.metadataService;
    }

    EmbraceSessionService getSessionService() {
        return this.sessionService;
    }

    @Nullable
    private Map<String, Object> normalizeProperties(@Nullable Map<String, Object> properties) {
        HashMap<String, Object> normalizedProperties = new HashMap();
        if (properties != null) {
            try {
                normalizedProperties = PropertyUtils.sanitizeProperties(properties);
            }
            catch (Exception e) {
                EmbraceLogger.logError("Exception occurred while normalizing the properties.", e, true);
            }
            return normalizedProperties;
        }
        return null;
    }

    public static enum AppFramework {
        NATIVE(1),
        REACT_NATIVE(2),
        UNITY(3);

        private final int value;

        private AppFramework(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }
    }
}

