package io.embrace.android.embracesdk;

/**
 * Listener for changes to the quality of the connection.
 */
public interface ConnectionQualityListener {
    /**
     * Notifies a listener of a change in device connection quality.
     * <p>
     * The quality can be one of {@link ConnectionQuality}, and a listener can be registered by
     * calling {@link Embrace#addConnectionQualityListener(ConnectionQualityListener)}.
     * <p>
     * A listener can be removed by calling {@link Embrace#removeConnectionQualityListener(ConnectionQualityListener)}.
     * <p>
     * The listener will be invoked immediately after registration with the last connection
     * quality measurement, and then invoked again for every change in quality.
     *
     * @param previousConnectionQuality the previously measured connection quality
     * @param newConnectionQuality the new connection quality
     * @param currentBandwidth the current estimated bandwidth in kilobits / second
     */
    void onConnectionQualityChange(
            ConnectionQuality previousConnectionQuality,
            ConnectionQuality newConnectionQuality,
            int currentBandwidth);
}
