package io.embrace.android.embracesdk;

import android.util.Pair;

import com.google.gson.annotations.SerializedName;

/**
 * Breadcrumbs that represent tap events.
 */
final class TapBreadcrumb implements Breadcrumb {

    /**
     * Name of the tapped element.
     */
    @SerializedName("tt")
    private final String tappedElementName;

    /**
     * Screen position (coordinates) of the tapped element.
     */
    @SerializedName("tl")
    private final String location;

    /**
     * The timestamp at which the event occurred.
     */
    @SerializedName("ts")
    private final Long timestamp;

    /**
     * Type of TapBreadcrumb that categorizes the kind interaction, based on
     * {@link TapBreadcrumbType} types.
     */
    @SerializedName("t")
    private final TapBreadcrumbType type;

    TapBreadcrumb(Pair<Float, Float> point,
                  String tappedElementName,
                  long timestamp,
                  TapBreadcrumbType tapBreadcrumbType) {

        this.timestamp = timestamp;
        this.type = tapBreadcrumbType;
        this.tappedElementName = tappedElementName;
        if (point != null) {
            float first = point.first != null ? point.first.intValue() : 0.0F;
            float second = point.second != null ? point.second.intValue() : 0.0F;
            this.location = (int) first + "," + (int) second;
        } else {
            this.location = "0,0";
        }
    }

    @Override
    public long getStartTime() {
        return timestamp;
    }

    enum TapBreadcrumbType {
        @SerializedName("s")
        TAP,
        @SerializedName("l")
        LONG_PRESS;
    }
}
