package io.embrace.android.embracesdk;

import java.io.Closeable;
import java.util.List;

/**
 * Detects and records which network the device is connected to.
 */
interface NetworkConnectivityService extends Closeable {
    /**
     * Gets the intervals during which the device was on WIFI, WAN, or not reachable;
     *
     * @param startTime the start time of the period to search
     * @param endTime the end time of the period to search
     * @return a list of intervals for each network type
     */
    List<Interval> getNetworkInterfaceIntervals(long startTime, long endTime);

    /**
     * Record the connection type at the start of the session and open a connectivity interval with it,
     * with a start time that matches the session start time.
     *
     * @param startTime of the session
     */
   void networkStatusOnSessionStarted(long startTime);
}
