/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.embracesdk;

import android.content.Context;
import android.content.res.Resources;
import com.fernandocejas.arrow.optional.Optional;

public final class BuildInfo {
    static final String BUILD_INFO_BUILD_ID = "emb_build_id";
    static final String BUILD_INFO_BUILD_TYPE = "emb_build_type";
    static final String BUILD_INFO_BUILD_FLAVOR = "emb_build_flavor";
    private static final String RES_TYPE_STRING = "string";
    private final String buildId;
    private final String buildType;
    private final String buildFlavor;

    BuildInfo(String buildId, String buildType, String buildFlavor) {
        this.buildId = buildId;
        this.buildType = buildType;
        this.buildFlavor = (String)Optional.fromNullable((Object)buildFlavor).orNull();
    }

    static BuildInfo fromResources(Context context) {
        try {
            int buildFlavorId = BuildInfo.getResourcesIdentifier(context, BUILD_INFO_BUILD_FLAVOR, RES_TYPE_STRING);
            return new BuildInfo(context.getResources().getString(BuildInfo.getResourcesIdentifier(context, BUILD_INFO_BUILD_ID, RES_TYPE_STRING)), context.getResources().getString(BuildInfo.getResourcesIdentifier(context, BUILD_INFO_BUILD_TYPE, RES_TYPE_STRING)), buildFlavorId != 0 ? context.getResources().getString(buildFlavorId) : null);
        }
        catch (Exception ex) {
            throw new RuntimeException("Failed to read build_info.xml", ex);
        }
    }

    private static int getResourcesIdentifier(Context context, String buildProperty, String type) {
        Resources resources = context.getResources();
        return resources.getIdentifier(buildProperty, type, context.getPackageName());
    }

    String getBuildId() {
        return this.buildId;
    }

    String getBuildType() {
        return this.buildType;
    }

    String getBuildFlavor() {
        return this.buildFlavor;
    }
}

