package io.embrace.android.embracesdk;

import com.google.gson.annotations.SerializedName;

/**
 * Represents a value over a particular interval. This is used for:
 * <ul>
 *     <li>Periods during which the device was charging</li>
 *     <li>Periods during which the device was in low power mode</li>
 *     <li>Periods during which the device was connected to Wifi, WAN, or no network</li>
 * </ul>
 */
final class Interval {
    @SerializedName("st")
    private final long startTime;

    @SerializedName("en")
    private final long endTime;

    @SerializedName("v")
    private final String value;

    Interval(long startTime, long endTime, String value) {
        this.startTime = startTime;
        this.endTime = endTime;
        this.value = value;
    }

    Interval(long startTime, long endTime) {
        this(startTime, endTime, null);
    }
}
