/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.embracesdk;

import android.app.usage.StorageStatsManager;
import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.net.Uri;
import android.os.Build;
import android.os.Environment;
import android.os.StatFs;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import android.view.WindowManager;
import androidx.annotation.NonNull;
import com.fernandocejas.arrow.checks.Preconditions;
import com.fernandocejas.arrow.optional.Optional;
import io.embrace.android.embracesdk.ActivityListener;
import io.embrace.android.embracesdk.ActivityService;
import io.embrace.android.embracesdk.AppInfo;
import io.embrace.android.embracesdk.BackgroundWorker;
import io.embrace.android.embracesdk.BuildInfo;
import io.embrace.android.embracesdk.DeviceInfo;
import io.embrace.android.embracesdk.DiskUsage;
import io.embrace.android.embracesdk.Embrace;
import io.embrace.android.embracesdk.EmbraceLogger;
import io.embrace.android.embracesdk.LocalConfig;
import io.embrace.android.embracesdk.MetadataService;
import io.embrace.android.embracesdk.MetadataUtils;
import io.embrace.android.embracesdk.PreferencesService;
import io.embrace.android.embracesdk.TelephonyInfo;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Locale;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

final class EmbraceMetadataService
implements MetadataService,
ActivityListener {
    private static final String UNKNOWN_VALUE = "UNKNOWN";
    private static final int DISK_USAGE_READ_INTERVAL_TIMEOUT = 30;
    private final TelephonyManager telephonyManager;
    private final WindowManager windowManager;
    private final PackageManager packageManager;
    private final StorageStatsManager storageStatsManager;
    private final ApplicationInfo applicationInfo;
    private final PreferencesService preferencesService;
    private final ActivityService activityService;
    private final BuildInfo buildInfo;
    private final LocalConfig localConfig;
    private final String deviceId;
    private final String packageName;
    private final String appVersionName;
    private final String appVersionCode;
    private final StatFs statFs = new StatFs(Environment.getDataDirectory().getPath());
    private final String reactNativeBundlePath;
    private final String javaScriptPatchNumber;
    private final String reactNativeVersion;
    private final boolean appUpdated;
    private final boolean osUpdated;
    private final Embrace.AppFramework appFramework;
    private volatile String activeSessionId;
    private volatile DiskUsage diskUsage;

    private EmbraceMetadataService(TelephonyManager telephonyManager, WindowManager windowManager, PackageManager packageManager, StorageStatsManager storageStatsManager, BuildInfo buildInfo, LocalConfig localConfig, ApplicationInfo applicationInfo, String deviceId, String packageName, String appVersionName, String appVersionCode, Embrace.AppFramework appFramework, boolean appUpdated, boolean osUpdated, PreferencesService preferencesService, ActivityService activityService, String reactNativeBundlePath, String javaScriptPatchNumber, String reactNativeVersion) {
        this.telephonyManager = telephonyManager;
        this.windowManager = windowManager;
        this.packageManager = packageManager;
        this.storageStatsManager = storageStatsManager;
        this.buildInfo = (BuildInfo)Preconditions.checkNotNull((Object)buildInfo);
        this.localConfig = (LocalConfig)Preconditions.checkNotNull((Object)localConfig);
        this.applicationInfo = applicationInfo;
        this.deviceId = (String)Preconditions.checkNotNull((Object)deviceId);
        this.packageName = (String)Preconditions.checkNotNull((Object)packageName);
        this.appVersionName = (String)Preconditions.checkNotNull((Object)appVersionName);
        this.appVersionCode = (String)Preconditions.checkNotNull((Object)appVersionCode);
        this.appFramework = (Embrace.AppFramework)((Object)Preconditions.checkNotNull((Object)((Object)appFramework)));
        this.appUpdated = appUpdated;
        this.osUpdated = osUpdated;
        this.preferencesService = (PreferencesService)Preconditions.checkNotNull((Object)preferencesService);
        this.activityService = (ActivityService)Preconditions.checkNotNull((Object)activityService);
        if (appFramework == Embrace.AppFramework.REACT_NATIVE) {
            this.reactNativeBundlePath = reactNativeBundlePath;
            this.javaScriptPatchNumber = javaScriptPatchNumber;
            this.reactNativeVersion = reactNativeVersion;
        } else {
            this.reactNativeBundlePath = null;
            this.javaScriptPatchNumber = null;
            this.reactNativeVersion = null;
        }
        activityService.addListener(this);
        this.retrieveDiskUsageOnce(localConfig.getConfigurations().getApp().getReportDiskUsage());
    }

    static EmbraceMetadataService ofContext(Context context, BuildInfo buildInfo, LocalConfig localConfig, Embrace.AppFramework appFramework, PreferencesService preferencesService, ActivityService activityService) {
        String appVersionCode;
        String appVersionName;
        Preconditions.checkNotNull((Object)context, (Object)"Device context is null");
        StorageStatsManager storageStatsManager = null;
        if (Build.VERSION.SDK_INT >= 26) {
            storageStatsManager = (StorageStatsManager)context.getSystemService("storagestats");
        }
        try {
            PackageInfo packageInfo = context.getPackageManager().getPackageInfo(context.getPackageName(), 0);
            appVersionName = String.valueOf(packageInfo.versionName).trim();
            appVersionCode = String.valueOf(packageInfo.versionCode);
        }
        catch (Exception e) {
            appVersionName = UNKNOWN_VALUE;
            appVersionCode = UNKNOWN_VALUE;
        }
        Optional<String> lastKnownAppVersion = preferencesService.getAppVersion();
        boolean isAppUpdated = lastKnownAppVersion.isPresent() && !((String)lastKnownAppVersion.get()).equalsIgnoreCase(appVersionName);
        Optional<String> lastKnownOsVersion = preferencesService.getOsVersion();
        boolean isOsUpdated = lastKnownOsVersion.isPresent() && !((String)lastKnownOsVersion.get()).equalsIgnoreCase(String.valueOf(Build.VERSION.RELEASE));
        String reactNativeBundlePath = null;
        String javaScriptPatchNumber = null;
        String reactNativeVersion = null;
        if (appFramework == Embrace.AppFramework.REACT_NATIVE) {
            reactNativeBundlePath = preferencesService.getJavaScriptBundleURL().isPresent() ? EmbraceMetadataService.getReactNativeBundleHashFromFile(context, (String)preferencesService.getJavaScriptBundleURL().get()) : buildInfo.getBuildId();
            if (preferencesService.getJavaScriptPatchNumber().isPresent()) {
                javaScriptPatchNumber = (String)preferencesService.getJavaScriptPatchNumber().get();
            }
            if (preferencesService.getReactNativeVersionNumber().isPresent()) {
                reactNativeVersion = (String)preferencesService.getReactNativeVersionNumber().get();
            }
        }
        return new EmbraceMetadataService((TelephonyManager)context.getSystemService("phone"), (WindowManager)context.getSystemService("window"), context.getPackageManager(), storageStatsManager, buildInfo, localConfig, context.getApplicationInfo(), MetadataUtils.createDeviceId(context.getContentResolver()), context.getPackageName(), appVersionName, appVersionCode, appFramework, isAppUpdated, isOsUpdated, preferencesService, activityService, reactNativeBundlePath, javaScriptPatchNumber, reactNativeVersion);
    }

    private static String getBundleAssetName(String bundleUrl) {
        return bundleUrl.substring((Uri.parse((String)bundleUrl).getScheme() + "://").length());
    }

    /*
     * Exception decompiling
     */
    private static String getReactNativeBundleHashFromFile(Context context, @NonNull String bundleUrl) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static String hashBundleToMD5(byte[] bundle) throws NoSuchAlgorithmException {
        MessageDigest md = MessageDigest.getInstance("MD5");
        byte[] bundleHashed = md.digest(bundle);
        StringBuilder sb = new StringBuilder();
        for (byte b : bundleHashed) {
            sb.append(String.format("%02x", b & 0xFF));
        }
        String hashBundle = sb.toString();
        return hashBundle.toUpperCase(Locale.getDefault());
    }

    @Override
    public TelephonyInfo getTelephonyInfo() {
        String mcc = null;
        String mnc = null;
        String carrierName = null;
        String carrierCountry = null;
        if (this.telephonyManager != null) {
            try {
                String networkOperator = this.telephonyManager.getNetworkOperator();
                carrierName = this.telephonyManager.getNetworkOperatorName();
                carrierCountry = this.telephonyManager.getNetworkCountryIso();
                if (!(TextUtils.isEmpty((CharSequence)networkOperator) || networkOperator.length() != 5 && networkOperator.length() != 6)) {
                    mcc = networkOperator.substring(0, 3);
                    mnc = networkOperator.substring(3);
                }
            }
            catch (Exception ex) {
                EmbraceLogger.logDebug("Could not retrieve telephony information", ex);
            }
        }
        return new TelephonyInfo(carrierName, carrierCountry, mcc, mnc);
    }

    @Override
    public Optional<String> getAppVersionCodeForRequest() {
        return MetadataUtils.getVersionCodeForRequest(this.packageManager, this.packageName);
    }

    @Override
    public String getDeviceId() {
        return this.deviceId;
    }

    @Override
    public String getAppVersionCode() {
        return this.appVersionCode;
    }

    @Override
    public String getAppVersionName() {
        return this.appVersionName;
    }

    @Override
    public DeviceInfo getDeviceInfo() {
        return DeviceInfo.newBuilder().withManufacturer(MetadataUtils.getDeviceManufacturer()).withModel(MetadataUtils.getModel()).withArchitecture(MetadataUtils.getArchitecture()).withJailbroken(MetadataUtils.isJailbroken()).withLocale(MetadataUtils.getLocale()).withInternalStorageTotalCapacity(MetadataUtils.getInternalStorageTotalCapacity(this.statFs)).withOperatingSystemType(MetadataUtils.getOperatingSystemType()).withOperatingSystemVersion(MetadataUtils.getOperatingSystemVersion()).withOperatingSystemVersionCode(MetadataUtils.getOperatingSystemVersionCode()).withScreenResolution((String)MetadataUtils.getScreenResolution(this.windowManager).orNull()).withTimezoneDescription(MetadataUtils.getTimezoneId()).withUptime(MetadataUtils.getSystemUptime()).build();
    }

    @Override
    public AppInfo getAppInfo() {
        return AppInfo.newBuilder().withSdkVersion(String.valueOf("4.5.4")).withSdkSimpleVersion(String.valueOf(53)).withBuildId(this.buildInfo.getBuildId()).withBuildType(this.buildInfo.getBuildType()).withBuildFlavor(this.buildInfo.getBuildFlavor()).withAppVersion(this.appVersionName).withAppFramework(this.appFramework).withBundleVersion(this.appVersionCode).withEnvironment(MetadataUtils.appEnvironment(this.applicationInfo)).withAppUpdated(this.appUpdated).withOsUpdated(this.osUpdated).withAppUpdatedThisLaunch(this.appUpdated).withOsUpdatedThisLaunch(this.osUpdated).withReactNativeBundlePath(this.reactNativeBundlePath).withJavaScriptPatchNumber(this.javaScriptPatchNumber).withReactNativeVersion(this.reactNativeVersion).build();
    }

    @Override
    public boolean isDebug() {
        return MetadataUtils.isDebug(this.applicationInfo);
    }

    @Override
    public String getAppId() {
        return this.localConfig.getAppId();
    }

    @Override
    public boolean isAppUpdated() {
        return this.appUpdated;
    }

    @Override
    public boolean isOsUpdated() {
        return this.osUpdated;
    }

    @Override
    public Optional<String> getActiveSessionId() {
        return Optional.fromNullable((Object)this.activeSessionId);
    }

    @Override
    public void setActiveSessionId(String sessionId) {
        this.activeSessionId = sessionId;
    }

    @Override
    public String getAppState() {
        if (this.activityService.isInBackground()) {
            return "background";
        }
        return "active";
    }

    @Override
    public DiskUsage getDiskUsage() {
        return this.diskUsage;
    }

    private void retrieveDiskUsageOnce(boolean reportAppDiskUsage) {
        try {
            this.diskUsage = this.retrieveDiskUsage(reportAppDiskUsage).get(30L, TimeUnit.SECONDS);
        }
        catch (TimeoutException ex) {
            EmbraceLogger.logWarning("Failed to retrieve disk usage data. Timeout reached.", ex);
        }
        catch (ExecutionException ex) {
            EmbraceLogger.logWarning("Failed to retrieve disk usage data. Execution error occurred", ex);
        }
        catch (Exception ex) {
            EmbraceLogger.logWarning("Failed to retrieve disk usage data", ex);
        }
    }

    private Future<DiskUsage> retrieveDiskUsage(boolean reportAppDiskUsage) {
        BackgroundWorker worker = BackgroundWorker.ofSingleThread("Metadata service");
        return worker.submit(() -> {
            Optional<Long> usage;
            long free = MetadataUtils.getInternalStorageFreeCapacity(this.statFs);
            if (Build.VERSION.SDK_INT >= 26 && reportAppDiskUsage && (usage = MetadataUtils.getDeviceDiskAppUsage(this.storageStatsManager, this.packageManager, this.packageName)).isPresent()) {
                return new DiskUsage((Long)usage.get(), free);
            }
            return new DiskUsage(free);
        });
    }

    @Override
    public void applicationStartupComplete() {
        String appVersion = this.getAppVersionName();
        String osVersion = String.valueOf(Build.VERSION.RELEASE);
        String localDeviceId = this.getDeviceId();
        long installDate = System.currentTimeMillis();
        EmbraceLogger.logDebug(String.format(Locale.getDefault(), "Setting metadata on preferences service. App version: {%s}, OS version {%s}, device ID: {%s}, install date: {%d}", appVersion, osVersion, localDeviceId, installDate));
        this.preferencesService.setAppVersion(appVersion);
        this.preferencesService.setOsVersion(osVersion);
        this.preferencesService.setDeviceIdentifier(localDeviceId);
        if (!this.preferencesService.getInstallDate().isPresent()) {
            this.preferencesService.setInstallDate(installDate);
        }
    }
}

