/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.embracesdk.networking;

import io.embrace.android.embracesdk.networking.EmbraceConnection;
import io.embrace.android.embracesdk.networking.EmbraceUrl;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.ProtocolException;
import java.util.List;
import java.util.Map;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSocketFactory;

public class EmbraceConnectionImpl
implements EmbraceConnection {
    private HttpURLConnection httpURLConnection;
    private EmbraceUrl url;
    private Integer responseCode = null;

    public EmbraceConnectionImpl(HttpURLConnection embraceConnection, EmbraceUrl url) {
        this.httpURLConnection = embraceConnection;
        this.url = url;
    }

    @Override
    public boolean isHttps() {
        return this.httpURLConnection instanceof HttpsURLConnection;
    }

    @Override
    public void setRequestMethod(String method) throws ProtocolException {
        this.httpURLConnection.setRequestMethod(method);
    }

    @Override
    public void setDoOutput(Boolean doOutput) {
        this.httpURLConnection.setDoOutput(doOutput);
    }

    @Override
    public void setConnectTimeout(Integer timeout) {
        this.httpURLConnection.setConnectTimeout(timeout);
    }

    @Override
    public void setReadTimeout(Integer readTimeout) {
        this.httpURLConnection.setReadTimeout(readTimeout);
    }

    @Override
    public void setRequestProperty(String key, String value) {
        this.httpURLConnection.setRequestProperty(key, value);
    }

    @Override
    public EmbraceUrl getURL() {
        return this.url;
    }

    @Override
    public String getRequestMethod() {
        return this.httpURLConnection.getRequestMethod();
    }

    @Override
    public String getHeaderField(String key) {
        return this.httpURLConnection.getHeaderField(key);
    }

    @Override
    public Map<String, List<String>> getHeaderFields() {
        return this.httpURLConnection.getHeaderFields();
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        return this.httpURLConnection.getOutputStream();
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return this.httpURLConnection.getInputStream();
    }

    @Override
    public InputStream getErrorStream() {
        return this.httpURLConnection.getErrorStream();
    }

    @Override
    public void connect() throws IOException {
        this.httpURLConnection.connect();
    }

    @Override
    public int getResponseCode() throws IOException {
        if (this.responseCode == null) {
            return this.httpURLConnection.getResponseCode();
        }
        return this.responseCode;
    }

    @Override
    public String getResponseMessage() throws IOException {
        return this.httpURLConnection.getResponseMessage();
    }

    @Override
    public void setSSLSocketFactory(SSLSocketFactory factory) {
        ((HttpsURLConnection)this.httpURLConnection).setSSLSocketFactory(factory);
    }

    @Override
    public SSLSocketFactory getSSLSocketFactory() {
        return ((HttpsURLConnection)this.httpURLConnection).getSSLSocketFactory();
    }
}

