/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.embracesdk;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import com.fernandocejas.arrow.checks.Preconditions;
import io.embrace.android.embracesdk.EmbraceLogger;
import io.embrace.android.embracesdk.Interval;
import io.embrace.android.embracesdk.MemoryCleanerListener;
import io.embrace.android.embracesdk.MemoryCleanerService;
import io.embrace.android.embracesdk.NetworkConnectivityService;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;

class EmbraceNetworkConnectivityService
extends BroadcastReceiver
implements NetworkConnectivityService,
MemoryCleanerListener {
    private final IntentFilter intentFilter = new IntentFilter("android.net.conn.CONNECTIVITY_CHANGE");
    private final NavigableMap<Long, NetworkStatus> networkReachable;
    private final ConnectivityManager connectivityManager;
    private final Context context;

    public EmbraceNetworkConnectivityService(Context context, MemoryCleanerService memoryCleanerService) {
        this.context = (Context)Preconditions.checkNotNull((Object)context, (Object)"context must not be null");
        this.connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
        this.networkReachable = new TreeMap<Long, NetworkStatus>();
        ((MemoryCleanerService)Preconditions.checkNotNull((Object)memoryCleanerService)).addListener(this);
        try {
            context.registerReceiver((BroadcastReceiver)this, this.intentFilter);
        }
        catch (Exception ex) {
            EmbraceLogger.logDebug("Failed to register EmbraceNetworkConnectivityService broadcast receiver. Connectivity status will be unavailable.", ex);
        }
    }

    public void onReceive(Context context, Intent intent) {
        try {
            NetworkInfo networkInfo = this.connectivityManager.getActiveNetworkInfo();
            if (networkInfo != null && networkInfo.isConnected()) {
                if (networkInfo.getType() == 1) {
                    this.saveStatus(NetworkStatus.WIFI);
                } else if (networkInfo.getType() == 0) {
                    this.saveStatus(NetworkStatus.WAN);
                }
            } else {
                this.saveStatus(NetworkStatus.NOT_REACHABLE);
            }
        }
        catch (Exception ex) {
            EmbraceLogger.logDebug("Failed to handle CONNECTIVITY_ACTION broadcast", ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Interval> getNetworkInterfaceIntervals(long startTime, long endTime) {
        EmbraceNetworkConnectivityService embraceNetworkConnectivityService = this;
        synchronized (embraceNetworkConnectivityService) {
            ArrayList<Interval> results = new ArrayList<Interval>();
            for (Map.Entry<Long, NetworkStatus> entry : this.networkReachable.subMap(startTime, endTime).entrySet()) {
                long currentTime;
                Long next = this.networkReachable.higherKey(currentTime = entry.getKey().longValue());
                results.add(new Interval(currentTime, next != null ? next : endTime, entry.getValue().getName()));
            }
            return results;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveStatus(NetworkStatus networkStatus) {
        EmbraceNetworkConnectivityService embraceNetworkConnectivityService = this;
        synchronized (embraceNetworkConnectivityService) {
            if (this.networkReachable.isEmpty() || !this.networkReachable.lastEntry().getValue().equals((Object)networkStatus)) {
                this.networkReachable.put(System.currentTimeMillis(), networkStatus);
            }
        }
    }

    @Override
    public void close() {
        this.context.unregisterReceiver((BroadcastReceiver)this);
    }

    @Override
    public void cleanCollections() {
        this.networkReachable.clear();
    }

    private static enum NetworkStatus {
        NOT_REACHABLE("none"),
        WIFI("wifi"),
        WAN("wan");

        private final String name;

        private NetworkStatus(String name) {
            this.name = name;
        }

        String getName() {
            return this.name;
        }
    }
}

