package io.embrace.android.embracesdk.network.http;

import java.lang.reflect.Method;
import java.net.HttpURLConnection;
import java.net.Proxy;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;

import io.embrace.android.embracesdk.network.EmbraceUrlStreamHandler;


/**
 * HTTP-specific implementation of EmbraceURLStreamHandler.
 */
public final class EmbraceHttpUrlStreamHandler extends EmbraceUrlStreamHandler {
    static final int PORT = 80;

    /**
     * Given the base URLStreamHandler that will be wrapped, constructs the instance.
     */
    public EmbraceHttpUrlStreamHandler(URLStreamHandler handler) {
        super(handler);
    }

    @Override
    public final int getDefaultPort() {
        return PORT;
    }

    @Override
    protected Method getMethodOpenConnection(Class<URL> url) throws NoSuchMethodException {
        Method method = this.handler.getClass().getDeclaredMethod(METHOD_NAME_OPEN_CONNECTION, url);

        method.setAccessible(true);
        return method;
    }

    @Override
    protected Method getMethodOpenConnection(Class<URL> url, Class<Proxy> proxy) throws NoSuchMethodException {
        Method method = this.handler.getClass().getDeclaredMethod(METHOD_NAME_OPEN_CONNECTION, url, proxy);

        method.setAccessible(true);
        return method;
    }

    @Override
    protected URLConnection newEmbraceUrlConnection(URLConnection connection) {
        if (!(connection instanceof HttpURLConnection)) {
            return connection;
        }
        if (enableRequestSizeCapture && !connection.getRequestProperties().containsKey("Accept-Encoding")) {
            // This disables automatic gzip decompression by HttpUrlConnection so that we can
            // accurately count the number of bytes. We handle the decompression ourselves.
            connection.setRequestProperty("Accept-Encoding", "gzip");
            return new EmbraceHttpUrlConnection<>((HttpURLConnection) connection, true);
        } else {
            // Do not transparently decompress if the user has specified an encoding themselves.
            // Even if they pass in 'gzip', we should return them the compressed response.
            return new EmbraceHttpUrlConnection<>((HttpURLConnection) connection, false);
        }
    }
}
