package io.embrace.android.embracesdk;

/**
 * Startup event info to save startup duration and startup threshold.
 */
class StartupEventInfo {

    private final Long duration;
    private final Long threshold;

    private StartupEventInfo(Builder builder) {
        this.duration = builder.duration;
        this.threshold = builder.threshold;
    }

    public Long getDuration() {
        return duration;
    }

    public Long getThreshold() {
        return threshold;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static final class Builder {
        private long duration;
        private long threshold;

        private Builder() {
        }

        public Builder withDuration(long duration) {
            this.duration = duration;
            return this;
        }

        public Builder withThreshold(long threshold) {
            this.threshold = threshold;
            return this;
        }

        public StartupEventInfo build() {
            return new StartupEventInfo(this);
        }
    }
}
