/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.embracesdk;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.fernandocejas.arrow.optional.Optional;
import io.embrace.android.embracesdk.ActivityListener;
import io.embrace.android.embracesdk.Embrace;
import io.embrace.android.embracesdk.EmbraceLogger;
import io.embrace.android.embracesdk.PreferencesService;
import io.embrace.android.embracesdk.UserInfo;
import io.embrace.android.embracesdk.UserService;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;

class EmbraceUserService
implements ActivityListener,
UserService {
    static final Pattern VALID_PERSONA = Pattern.compile("^[a-zA-Z0-9_]{1,32}$");
    static final int PERSONA_LIMIT = 10;
    private final PreferencesService preferencesService;
    private volatile UserInfo userInfo;

    EmbraceUserService(PreferencesService preferencesService) {
        this.preferencesService = preferencesService;
        this.userInfo = UserInfo.ofStored(preferencesService);
    }

    @Override
    public Optional<UserInfo> loadUserInfoFromDisk() {
        try {
            return Optional.fromNullable((Object)UserInfo.ofStored(this.preferencesService));
        }
        catch (Exception ex) {
            EmbraceLogger.logDebug("Failed to load user info from persistent storage.");
            return Optional.absent();
        }
    }

    @Override
    public UserInfo getUserInfo() {
        return this.userInfo;
    }

    @Override
    public void setUserIdentifier(@Nullable String userId) {
        if (this.getUserInfo().getUserId().equals(userId)) {
            return;
        }
        UserInfo.Builder builder = UserInfo.newBuilder(this.userInfo);
        this.userInfo = builder.withUserId(userId).build();
        try {
            if (userId != null) {
                Embrace.getInstance().getSessionService().getActiveSession().getUser().setUserId(userId);
            }
        }
        catch (Exception ex) {
            EmbraceLogger.logDebug("Failed to save user's id on the current Session. User info is null.");
        }
        this.preferencesService.setUserIdentifier(userId);
    }

    @Override
    public void clearUserIdentifier() {
        this.setUserIdentifier(null);
    }

    @Override
    public void setUsername(@Nullable String username) {
        if (this.getUserInfo().getUsername().equals(username)) {
            return;
        }
        UserInfo.Builder builder = UserInfo.newBuilder(this.userInfo);
        this.userInfo = builder.withUsername(username).build();
        try {
            if (username != null) {
                Embrace.getInstance().getSessionService().getActiveSession().getUser().setUsername(username);
            }
        }
        catch (Exception ex) {
            EmbraceLogger.logDebug("Failed to save user's username on the current Session. User info is null.");
        }
        this.preferencesService.setUsername(username);
    }

    @Override
    public void clearUsername() {
        this.setUsername(null);
    }

    @Override
    public void setUserEmail(@Nullable String email) {
        if (this.getUserInfo().getEmail().equals(email)) {
            return;
        }
        UserInfo.Builder builder = UserInfo.newBuilder(this.userInfo);
        this.userInfo = builder.withEmail(email).build();
        try {
            if (email != null) {
                Embrace.getInstance().getSessionService().getActiveSession().getUser().setEmail(email);
            }
        }
        catch (Exception ex) {
            EmbraceLogger.logDebug("Failed to save user's email on the current Session. User info is null.");
        }
        this.preferencesService.setUserEmailAddress(email);
    }

    @Override
    public void clearUserEmail() {
        this.setUserEmail(null);
    }

    @Override
    public void setUserAsPayer() {
        this.setUserPersona("payer");
    }

    @Override
    public void clearUserAsPayer() {
        this.clearUserPersona("payer");
    }

    @Override
    public void setUserPersona(@NonNull String persona) {
        if (!VALID_PERSONA.matcher(persona).matches()) {
            EmbraceLogger.logWarning("Ignoring persona " + persona + " as it does not match " + VALID_PERSONA.pattern());
            return;
        }
        if (this.userInfo.getPersonas().size() >= 10) {
            EmbraceLogger.logWarning("Cannot set persona as the limit of 10 has been reached");
            return;
        }
        if (this.userInfo.getPersonas().contains(persona)) {
            return;
        }
        UserInfo.Builder builder = UserInfo.newBuilder(this.userInfo);
        HashSet<String> personas = new HashSet<String>();
        if (builder.getPersonas() != null) {
            personas.addAll(builder.getPersonas());
        }
        personas.add(persona);
        this.userInfo = builder.withPersonas(personas).build();
        this.updatePersonas(personas);
    }

    @Override
    public void clearUserPersona(@NonNull String persona) {
        if (!this.userInfo.getPersonas().contains(persona)) {
            EmbraceLogger.logWarning("Persona '" + persona + "' is not set");
            return;
        }
        UserInfo.Builder builder = UserInfo.newBuilder(this.userInfo);
        HashSet<String> personas = new HashSet<String>();
        if (builder.getPersonas() != null) {
            personas.addAll(builder.getPersonas());
        }
        personas.remove(persona);
        this.userInfo = builder.withPersonas(personas).build();
        this.updatePersonas(personas);
    }

    @Override
    public void clearAllUserPersonas() {
        if (this.getUserInfo().getPersonas().size() == 0) {
            return;
        }
        UserInfo.Builder builder = UserInfo.newBuilder(this.userInfo);
        HashSet<String> personas = new HashSet<String>();
        if (this.preferencesService.getUserPayer()) {
            personas.add("payer");
        }
        if (this.preferencesService.isUsersFirstDay()) {
            personas.add("first_day");
        }
        this.userInfo = builder.withPersonas(personas).build();
        this.updatePersonas(personas);
    }

    private void updatePersonas(Set<String> personas) {
        try {
            Embrace.getInstance().getSessionService().getActiveSession().getUser().setPersonas(personas);
        }
        catch (Exception ex) {
            EmbraceLogger.logDebug("Failed to save user's personas on the current Session. User info is null.");
        }
        this.preferencesService.setUserPersonas(personas);
    }

    @Override
    public void clearAllUserInfo() {
        this.clearUserIdentifier();
        this.clearUserEmail();
        this.clearUsername();
        this.clearAllUserPersonas();
    }
}

