/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.embracesdk;

import com.fernandocejas.arrow.optional.Optional;
import com.google.gson.annotations.SerializedName;
import io.embrace.android.embracesdk.EmbraceSessionProperties;
import io.embrace.android.embracesdk.ExceptionError;
import io.embrace.android.embracesdk.Orientation;
import io.embrace.android.embracesdk.UserInfo;
import java.util.List;
import java.util.Map;

public class Session {
    @SerializedName(value="id")
    private final String sessionId;
    @SerializedName(value="st")
    private final Long startTime;
    @SerializedName(value="et")
    private final Long endTime;
    @SerializedName(value="sn")
    private final Integer number;
    @SerializedName(value="ht")
    private final Long lastHeartbeatTime;
    @SerializedName(value="tt")
    private final Long terminationTime;
    @SerializedName(value="ls")
    private final String lastState;
    @SerializedName(value="ba")
    private final Double startingBatteryLevel;
    @SerializedName(value="ce")
    private final Boolean endedCleanly;
    @SerializedName(value="tr")
    private final Boolean receivedTermination;
    @SerializedName(value="cs")
    private final Boolean coldStart;
    @SerializedName(value="ss")
    private final List<String> eventIds;
    @SerializedName(value="t")
    private final String sessionType;
    @SerializedName(value="il")
    private final List<String> infoLogIds;
    @SerializedName(value="wl")
    private final List<String> warningLogIds;
    @SerializedName(value="el")
    private final List<String> errorLogIds;
    @SerializedName(value="e")
    private final ExceptionError exceptionError;
    @SerializedName(value="ri")
    private final String crashReportId;
    @SerializedName(value="em")
    private final SessionLifeEventType endType;
    @SerializedName(value="sm")
    private final SessionLifeEventType startType;
    @SerializedName(value="oc")
    private final List<Orientation> orientations;
    @SerializedName(value="sp")
    private final Map<String, String> properties;
    private final transient UserInfo user;

    public String getSessionId() {
        return this.sessionId;
    }

    public UserInfo getUser() {
        return this.user;
    }

    public Long getStartTime() {
        return this.startTime;
    }

    public Long getEndTime() {
        return this.endTime;
    }

    public Integer getNumber() {
        return this.number;
    }

    public Long getLastHeartbeatTime() {
        return this.lastHeartbeatTime;
    }

    public Long getTerminationTime() {
        return this.terminationTime;
    }

    public String getLastState() {
        return this.lastState;
    }

    public Double getStartingBatteryLevel() {
        return this.startingBatteryLevel;
    }

    public Boolean isEndedCleanly() {
        return this.endedCleanly;
    }

    public Boolean isReceivedTermination() {
        return this.receivedTermination;
    }

    public Boolean isColdStart() {
        return this.coldStart;
    }

    public List<String> getEventIds() {
        return this.eventIds;
    }

    public String getSessionType() {
        return this.sessionType;
    }

    public List<String> getInfoLogIds() {
        return this.infoLogIds;
    }

    public List<String> getWarningLogIds() {
        return this.warningLogIds;
    }

    public List<String> getErrorLogIds() {
        return this.errorLogIds;
    }

    public ExceptionError getExceptionError() {
        return this.exceptionError;
    }

    public String getCrashReportId() {
        return this.crashReportId;
    }

    public SessionLifeEventType getEndType() {
        return this.endType;
    }

    public SessionLifeEventType getStartType() {
        return this.startType;
    }

    public List<Orientation> getOrientations() {
        return this.orientations;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    private Session(Builder builder) {
        this.sessionId = builder.sessionId;
        this.user = builder.user;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
        this.number = builder.number;
        this.lastHeartbeatTime = builder.lastHeartbeatTime;
        this.terminationTime = builder.terminationTime;
        this.lastState = builder.lastState;
        this.startingBatteryLevel = builder.startingBatteryLevel;
        this.endedCleanly = builder.endedCleanly;
        this.receivedTermination = builder.receivedTermination;
        this.coldStart = builder.coldStart;
        this.eventIds = builder.eventIds;
        this.sessionType = builder.sessionType;
        this.infoLogIds = builder.infoLogIds;
        this.warningLogIds = builder.warningLogIds;
        this.errorLogIds = builder.errorLogIds;
        this.exceptionError = builder.exceptionError;
        this.crashReportId = builder.crashReportId;
        this.startType = builder.startType;
        this.endType = builder.endType;
        this.orientations = builder.orientations;
        this.properties = builder.properties;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilder(Session copy) {
        Builder builder = new Builder();
        builder.sessionId = copy.getSessionId();
        builder.user = copy.getUser();
        builder.startTime = copy.getStartTime();
        builder.endTime = copy.getEndTime();
        builder.number = copy.getNumber();
        builder.lastHeartbeatTime = copy.getLastHeartbeatTime();
        builder.terminationTime = copy.getTerminationTime();
        builder.lastState = copy.getLastState();
        builder.startingBatteryLevel = copy.getStartingBatteryLevel();
        builder.endedCleanly = copy.isEndedCleanly();
        builder.receivedTermination = copy.isReceivedTermination();
        builder.coldStart = copy.isColdStart();
        builder.eventIds = copy.getEventIds();
        builder.sessionType = copy.getSessionType();
        builder.infoLogIds = copy.getInfoLogIds();
        builder.warningLogIds = copy.getWarningLogIds();
        builder.errorLogIds = copy.getErrorLogIds();
        builder.exceptionError = copy.getExceptionError();
        builder.crashReportId = copy.getCrashReportId();
        builder.startType = copy.getStartType();
        builder.endType = copy.getEndType();
        builder.orientations = copy.getOrientations();
        builder.properties = copy.getProperties();
        return builder;
    }

    public static final class Builder {
        private String sessionId;
        private UserInfo user;
        private Long startTime;
        private Long endTime;
        private Integer number;
        private Long lastHeartbeatTime;
        private Long terminationTime;
        private String lastState;
        private Double startingBatteryLevel;
        private Boolean endedCleanly;
        private Boolean receivedTermination;
        private Boolean coldStart;
        private List<String> eventIds;
        private String sessionType;
        private List<String> infoLogIds;
        private List<String> warningLogIds;
        private List<String> errorLogIds;
        private ExceptionError exceptionError;
        private String crashReportId;
        private SessionLifeEventType endType;
        private SessionLifeEventType startType;
        private List<Orientation> orientations;
        private Map<String, String> properties;

        private Builder() {
        }

        public Builder withSessionId(String sessionId) {
            this.sessionId = sessionId;
            return this;
        }

        public Builder withUserInfo(Optional<UserInfo> userInfo) {
            if (userInfo.isPresent()) {
                this.user = (UserInfo)userInfo.get();
            }
            return this;
        }

        public Builder withStartTime(Long startTime) {
            this.startTime = startTime;
            return this;
        }

        public Builder withEndTime(Long endTime) {
            this.endTime = endTime;
            return this;
        }

        public Builder withNumber(Integer number) {
            this.number = number;
            return this;
        }

        public Builder withLastHeartbeatTime(Long lastHeartbeatTime) {
            this.lastHeartbeatTime = lastHeartbeatTime;
            return this;
        }

        public Builder withTerminationTime(Long terminationTime) {
            this.terminationTime = terminationTime;
            return this;
        }

        public Builder withLastState(String lastState) {
            this.lastState = lastState;
            return this;
        }

        public Builder withStartingBatteryLevel(Optional<Float> startingBatteryLevel) {
            if (startingBatteryLevel.isPresent()) {
                this.startingBatteryLevel = ((Float)startingBatteryLevel.get()).floatValue();
            }
            return this;
        }

        public Builder withEndedCleanly(boolean endedCleanly) {
            this.endedCleanly = endedCleanly;
            return this;
        }

        public Builder withReceivedTermination(boolean receivedTermination) {
            this.receivedTermination = receivedTermination;
            return this;
        }

        public Builder withColdStart(boolean coldStart) {
            this.coldStart = coldStart;
            return this;
        }

        public Builder withEventIds(List<String> eventIds) {
            this.eventIds = eventIds;
            return this;
        }

        public Builder withSessionType(String sessionType) {
            this.sessionType = sessionType;
            return this;
        }

        public Builder withInfoLogIds(List<String> infoLogIds) {
            this.infoLogIds = infoLogIds;
            return this;
        }

        public Builder withWarningLogIds(List<String> warningLogIds) {
            this.warningLogIds = warningLogIds;
            return this;
        }

        public Builder withErrorLogIds(List<String> errorLogIds) {
            this.errorLogIds = errorLogIds;
            return this;
        }

        public Builder withExceptionErrors(ExceptionError exceptionError) {
            this.exceptionError = exceptionError;
            return this;
        }

        public Builder withCrashReportId(String crashReportId) {
            this.crashReportId = crashReportId;
            return this;
        }

        public Builder withEndType(SessionLifeEventType endType) {
            this.endType = endType;
            return this;
        }

        public Builder withStartType(SessionLifeEventType startType) {
            this.startType = startType;
            return this;
        }

        public Builder withProperties(EmbraceSessionProperties properties) {
            this.properties = properties.get();
            return this;
        }

        public Builder withOrientations(List<Orientation> orientations) {
            if (!orientations.isEmpty()) {
                this.orientations = orientations;
            }
            return this;
        }

        public Session build() {
            return new Session(this);
        }
    }

    static enum SessionLifeEventType {
        STATE,
        MANUAL,
        TIMED;

    }
}

