/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.embracesdk;

import android.content.Context;
import com.fernandocejas.arrow.checks.Preconditions;
import com.fernandocejas.arrow.optional.Optional;
import com.fernandocejas.arrow.strings.Charsets;
import com.google.gson.Gson;
import com.google.gson.stream.JsonReader;
import io.embrace.android.embracesdk.CacheService;
import io.embrace.android.embracesdk.EmbraceLogger;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;

class EmbraceCacheService
implements CacheService {
    private static final String EMBRACE_PREFIX = "emb_";
    private final Gson gson = new Gson();
    private final Context context;

    EmbraceCacheService(Context context) {
        this.context = (Context)Preconditions.checkNotNull((Object)context, (Object)"context must not be null");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> void cacheObject(String name, T object, Class<T> clazz) {
        BufferedWriter bw = null;
        FileWriter fw = null;
        File file = new File(this.context.getCacheDir(), EMBRACE_PREFIX + name);
        try {
            fw = new FileWriter(file.getAbsoluteFile());
            bw = new BufferedWriter(fw);
            bw.write(this.gson.toJson(object, clazz));
        }
        catch (Exception ex) {
            EmbraceLogger.logDebug("Failed to store cache object " + file.getPath(), ex);
        }
        finally {
            try {
                if (bw != null) {
                    bw.close();
                }
            }
            catch (Exception ex) {
                EmbraceLogger.logDebug("Failed to close cache writer " + file.getPath(), ex);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public <T> Optional<T> loadObject(String name, Class<T> clazz) {
        File file = new File(this.context.getCacheDir(), EMBRACE_PREFIX + name);
        try (FileInputStream fileInputStream = new FileInputStream(file);
             InputStreamReader inputStreamReader = new InputStreamReader((InputStream)fileInputStream, Charsets.UTF_8);
             JsonReader jsonreader = new JsonReader((Reader)inputStreamReader);){
            jsonreader.setLenient(true);
            Object obj = this.gson.fromJson(jsonreader, clazz);
            if (obj == null) return Optional.absent();
            Optional optional = Optional.of((Object)obj);
            return optional;
        }
        catch (FileNotFoundException ex) {
            EmbraceLogger.logDebug("Cache file cannot be found " + file.getPath());
            return Optional.absent();
        }
        catch (Exception ex) {
            EmbraceLogger.logDebug("Failed to read cache object " + file.getPath(), ex);
        }
        return Optional.absent();
    }

    @Override
    public <T> List<T> loadObjectsByRegex(String regex, Class<T> clazz) {
        Pattern pattern = Pattern.compile(regex);
        ArrayList<Object> objects = new ArrayList<Object>();
        for (File cache : this.context.getCacheDir().listFiles()) {
            if (!pattern.matcher(cache.getName()).find()) continue;
            try (FileInputStream fileInputStream = new FileInputStream(cache);
                 InputStreamReader inputStreamReader = new InputStreamReader((InputStream)fileInputStream, Charsets.UTF_8);
                 JsonReader jsonreader = new JsonReader((Reader)inputStreamReader);){
                jsonreader.setLenient(true);
                Object obj = this.gson.fromJson(jsonreader, clazz);
                if (obj == null) continue;
                objects.add(obj);
            }
            catch (FileNotFoundException ex) {
                EmbraceLogger.logDebug("Cache file cannot be found " + cache.getPath());
            }
            catch (Exception ex) {
                EmbraceLogger.logDebug("Failed to read cache object " + cache.getPath(), ex);
            }
        }
        return objects;
    }

    @Override
    public boolean deleteObject(String name) {
        File file = new File(this.context.getCacheDir(), EMBRACE_PREFIX + name);
        try {
            return file.delete();
        }
        catch (Exception ex) {
            EmbraceLogger.logDebug("Failed to delete cache object " + file.getPath());
            return false;
        }
    }

    @Override
    public boolean deleteObjectsByRegex(String regex) {
        Pattern pattern = Pattern.compile(regex);
        boolean result = false;
        for (File cache : this.context.getCacheDir().listFiles()) {
            if (!pattern.matcher(cache.getName()).find()) continue;
            try {
                result = cache.delete();
            }
            catch (Exception ex) {
                EmbraceLogger.logDebug("Failed to delete cache object " + cache.getPath());
            }
        }
        return result;
    }
}

