/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.embracesdk.network.http;

import io.embrace.android.embracesdk.EmbraceLogger;
import io.embrace.android.embracesdk.HttpPathOverrideRequest;
import java.nio.charset.Charset;
import java.util.Locale;
import java.util.regex.Pattern;

public class EmbraceHttpPathOverride {
    protected static final String PATH_OVERRIDE = "x-emb-path";
    private static final Integer RELATIVE_PATH_MAX_LENGTH = 1024;
    private static final Pattern RELATIVE_PATH_PATTERN = Pattern.compile("[A-Za-z0-9-._~:/\\[\\]@!$&'()*+,;=]+");

    public static String getURLString(HttpPathOverrideRequest request) {
        String url;
        try {
            String pathOverride = request.getHeaderByName(PATH_OVERRIDE);
            url = pathOverride != null && EmbraceHttpPathOverride.validatePathOverride(pathOverride).booleanValue() ? request.getOverriddenURL(pathOverride) : request.getURLString();
        }
        catch (Exception e) {
            url = request.getURLString();
        }
        return url;
    }

    private static Boolean validatePathOverride(String path) {
        if (path == null) {
            EmbraceLogger.logError("URL relative path cannot be null");
            return false;
        }
        if (path.length() == 0) {
            EmbraceLogger.logError("Relative path must have non-zero length");
            return false;
        }
        if (path.length() > RELATIVE_PATH_MAX_LENGTH) {
            EmbraceLogger.logError(String.format(Locale.US, "Relative path %s is greater than the maximum allowed length of %d. It will be ignored", path, RELATIVE_PATH_MAX_LENGTH));
            return false;
        }
        if (!Charset.forName("US-ASCII").newEncoder().canEncode(path)) {
            EmbraceLogger.logError(String.format(Locale.US, "Relative path must not contain unicode characters. Relative path %s will be ignored.", path));
            return false;
        }
        if (!path.startsWith("/")) {
            EmbraceLogger.logError("Relative path must start with a /");
            return false;
        }
        if (!RELATIVE_PATH_PATTERN.matcher(path).matches()) {
            EmbraceLogger.logError(String.format(Locale.US, "Relative path contains invalid chars. Relative path %s will be ignored.", path));
            return false;
        }
        return true;
    }
}

