/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.embracesdk;

import com.google.gson.annotations.SerializedName;
import io.embrace.android.embracesdk.AppInfo;
import io.embrace.android.embracesdk.DeviceInfo;
import io.embrace.android.embracesdk.NativeCrash;
import java.util.Map;

class NativeCrashData {
    @SerializedName(value="report_id")
    private final String id;
    @SerializedName(value="sid")
    private final String sessionId;
    @SerializedName(value="ts")
    private final Long timestamp;
    @SerializedName(value="state")
    private final String appState;
    @SerializedName(value="meta")
    private final NativeCrashMetadata metadata;
    @SerializedName(value="crash")
    private final String crash;
    @SerializedName(value="symbols")
    private Map<String, String> symbols;

    public NativeCrashData(String id, String sessionId, Long timestamp, String appState, NativeCrashMetadata metadata, String crash, Map<String, String> symbols) {
        this.id = id;
        this.sessionId = sessionId;
        this.timestamp = timestamp;
        this.appState = appState;
        this.metadata = metadata;
        this.crash = crash;
        this.symbols = symbols;
    }

    public void setSymbols(Map<String, String> symbols) {
        this.symbols = symbols;
    }

    public String getNativeCrashId() {
        return this.id;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public Long getTimestamp() {
        return this.timestamp;
    }

    public String getAppState() {
        return this.appState;
    }

    public NativeCrashMetadata getMetadata() {
        return this.metadata;
    }

    public NativeCrash getCrash() {
        return new NativeCrash(this.id, this.crash, this.symbols);
    }

    public Map<String, String> getSymbols() {
        return this.symbols;
    }

    public static class NativeCrashMetadata {
        @SerializedName(value="a")
        private final AppInfo appInfo;
        @SerializedName(value="d")
        private final DeviceInfo deviceInfo;

        NativeCrashMetadata(AppInfo appInfo, DeviceInfo deviceInfo) {
            this.appInfo = appInfo;
            this.deviceInfo = deviceInfo;
        }

        public DeviceInfo getDeviceInfo() {
            return this.deviceInfo;
        }

        public AppInfo getAppInfo() {
            return this.appInfo;
        }
    }
}

