/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.embracesdk;

import android.app.Activity;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.view.View;
import com.fernandocejas.arrow.checks.Preconditions;
import com.fernandocejas.arrow.optional.Optional;
import io.embrace.android.embracesdk.ActivityService;
import io.embrace.android.embracesdk.ApiClient;
import io.embrace.android.embracesdk.ConfigService;
import io.embrace.android.embracesdk.EmbraceLogger;
import io.embrace.android.embracesdk.ScreenshotService;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;

final class EmbraceScreenshotService
implements ScreenshotService {
    private static final long SCREENSHOT_COOLDOWN = 3000L;
    private static final int SCREENSHOT_JPEG_COMPRESSION_VALUE = 70;
    private final ActivityService activityService;
    private final ConfigService configService;
    private final ApiClient apiClient;
    private volatile long lastScreenshot;

    public EmbraceScreenshotService(ActivityService activityService, ConfigService configService, ApiClient apiClient) {
        this.activityService = (ActivityService)Preconditions.checkNotNull((Object)activityService);
        this.configService = (ConfigService)Preconditions.checkNotNull((Object)configService);
        this.apiClient = (ApiClient)Preconditions.checkNotNull((Object)apiClient);
    }

    @Override
    public boolean takeScreenshotLogEvent(String logId) {
        return this.takeScreenshot(logId, null);
    }

    @Override
    public boolean takeScreenshotMoment(String eventId) {
        return this.takeScreenshot(null, eventId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean takeScreenshot(String logId, String eventId) {
        EmbraceScreenshotService embraceScreenshotService = this;
        synchronized (embraceScreenshotService) {
            long timestamp = System.currentTimeMillis();
            if (this.activityService.isInBackground() || !this.configService.getConfig().getScreenshotsEnabled().booleanValue() || timestamp - this.lastScreenshot < 3000L) {
                EmbraceLogger.logDebug("Screenshots are disabled, app is backgrounded, or cooling down");
                return false;
            }
            Optional<Activity> optionalActivity = this.activityService.getForegroundActivity();
            if (optionalActivity.isPresent()) {
                byte[] screenshot = this.screenshot((Activity)optionalActivity.get());
                this.lastScreenshot = timestamp;
                if (eventId != null) {
                    this.apiClient.sendMomentScreenshot(screenshot, eventId);
                } else if (logId != null) {
                    this.apiClient.sendLogScreenshot(screenshot, logId);
                } else {
                    return false;
                }
                return true;
            }
            EmbraceLogger.logDebug("Screenshot cannot be taken as there is no active activity");
            return false;
        }
    }

    private byte[] screenshot(Activity activity) {
        Bitmap screenshot = this.takeScreenshot(activity);
        if (screenshot == null) {
            EmbraceLogger.logDebug("Screenshot returned was null");
            return new byte[0];
        }
        EmbraceLogger.logDebug("Compressing screenshot");
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        try {
            screenshot.compress(Bitmap.CompressFormat.JPEG, 70, (OutputStream)stream);
        }
        catch (OutOfMemoryError e) {
            EmbraceLogger.logDebug("Failed to compress screenshot due insufficient memory.", e);
            return new byte[0];
        }
        screenshot.recycle();
        return stream.toByteArray();
    }

    private Bitmap takeScreenshot(Activity activity) {
        View view;
        if (activity != null && (view = activity.getWindow().getDecorView()) != null && view.getWidth() > 0 && view.getHeight() > 0) {
            try {
                Bitmap screenshot = Bitmap.createBitmap((int)view.getWidth(), (int)view.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
                view.draw(new Canvas(screenshot));
                return screenshot;
            }
            catch (OutOfMemoryError e) {
                EmbraceLogger.logDebug("Failed to take screenshot due insufficient memory.", e);
                return null;
            }
        }
        return null;
    }
}

