/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.embracesdk;

import android.app.ActivityManager;
import android.content.Context;
import com.fernandocejas.arrow.checks.Preconditions;
import io.embrace.android.embracesdk.EmbraceLogger;
import io.embrace.android.embracesdk.MemoryCleanerListener;
import io.embrace.android.embracesdk.MemoryCleanerService;
import io.embrace.android.embracesdk.MemorySample;
import io.embrace.android.embracesdk.MemoryService;
import io.embrace.android.embracesdk.MemoryWarning;
import io.embrace.android.embracesdk.ScheduledWorker;
import java.util.ArrayList;
import java.util.List;
import java.util.NavigableMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.TimeUnit;

class EmbraceMemoryService
implements MemoryService,
MemoryCleanerListener {
    private final Runtime runtime = Runtime.getRuntime();
    private final ScheduledWorker memoryWorker;
    private final NavigableMap<Long, MemorySample> memorySamples;
    private final NavigableMap<Long, MemoryWarning> memoryWarnings;
    private static final int BYTES_IN_MB = 0x100000;

    public EmbraceMemoryService(ActivityManager activityManager, MemoryCleanerService memoryCleanerService) {
        Preconditions.checkNotNull((Object)activityManager, (Object)"activityManager must not be null");
        this.memoryWorker = ScheduledWorker.ofSingleThread("Memory Service");
        this.memoryWorker.scheduleAtFixedRate(() -> this.queryMemory(activityManager), 0L, 2L, TimeUnit.SECONDS);
        this.memorySamples = new ConcurrentSkipListMap<Long, MemorySample>();
        this.memoryWarnings = new ConcurrentSkipListMap<Long, MemoryWarning>();
        ((MemoryCleanerService)Preconditions.checkNotNull((Object)memoryCleanerService)).addListener(this);
    }

    public static EmbraceMemoryService ofContext(Context context, MemoryCleanerService memoryCleanerService) {
        return new EmbraceMemoryService((ActivityManager)context.getSystemService("activity"), memoryCleanerService);
    }

    private void queryMemory(ActivityManager activityManager) {
        try {
            ActivityManager.MemoryInfo memoryInfo = new ActivityManager.MemoryInfo();
            activityManager.getMemoryInfo(memoryInfo);
            long heapUsed = (this.runtime.totalMemory() - this.runtime.freeMemory()) / 0x100000L;
            long systemAvailable = memoryInfo.availMem / 0x100000L;
            long timestamp = System.currentTimeMillis();
            this.memorySamples.put(timestamp, new MemorySample(timestamp, heapUsed, systemAvailable));
        }
        catch (Exception ex) {
            EmbraceLogger.logDebug("Failed to query for memory usage", ex);
        }
    }

    @Override
    public List<MemorySample> getMemorySamples(long startTime, long endTime) {
        return new ArrayList<MemorySample>(this.memorySamples.subMap(startTime, endTime).values());
    }

    @Override
    public List<MemoryWarning> getMemoryWarnings(long startTime, long endTime) {
        return new ArrayList<MemoryWarning>(this.memoryWarnings.subMap(startTime, endTime).values());
    }

    @Override
    public void close() {
        EmbraceLogger.logDebug("Stopping EmbraceMemoryService");
        this.memoryWorker.close();
    }

    @Override
    public void onMemoryWarning() {
        long timestamp = System.currentTimeMillis();
        this.memoryWarnings.put(timestamp, new MemoryWarning(timestamp));
    }

    @Override
    public void cleanCollections() {
        this.memorySamples.clear();
        this.memoryWarnings.clear();
    }
}

