/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.embracesdk;

import com.fernandocejas.arrow.checks.Preconditions;
import com.fernandocejas.arrow.optional.Optional;
import io.embrace.android.embracesdk.ApiClient;
import io.embrace.android.embracesdk.Crash;
import io.embrace.android.embracesdk.CrashService;
import io.embrace.android.embracesdk.EmbraceEvent;
import io.embrace.android.embracesdk.EmbraceLogger;
import io.embrace.android.embracesdk.EmbraceUncaughtExceptionHandler;
import io.embrace.android.embracesdk.Event;
import io.embrace.android.embracesdk.EventMessage;
import io.embrace.android.embracesdk.EventService;
import io.embrace.android.embracesdk.JsException;
import io.embrace.android.embracesdk.LocalConfig;
import io.embrace.android.embracesdk.MetadataService;
import io.embrace.android.embracesdk.SessionService;
import io.embrace.android.embracesdk.UserService;

final class EmbraceCrashService
implements CrashService {
    private static final String CRASH_REPORT_EVENT_NAME = "_crash_report";
    private final LocalConfig localConfig;
    private final SessionService sessionService;
    private final MetadataService metadataService;
    private final ApiClient apiClient;
    private final UserService userService;
    private final EventService eventService;
    private boolean mainCrashHandled = false;
    private JsException jsException;

    EmbraceCrashService(LocalConfig localConfig, SessionService sessionService, MetadataService metadataService, ApiClient apiClient, UserService userService, EventService eventService) {
        this.localConfig = (LocalConfig)Preconditions.checkNotNull((Object)localConfig);
        if (this.localConfig.getConfigurations().getCrashHandler().getEnabled().booleanValue()) {
            this.registerExceptionHandler();
        }
        this.sessionService = (SessionService)Preconditions.checkNotNull((Object)sessionService);
        this.metadataService = (MetadataService)Preconditions.checkNotNull((Object)metadataService);
        this.apiClient = (ApiClient)Preconditions.checkNotNull((Object)apiClient);
        this.userService = (UserService)Preconditions.checkNotNull((Object)userService);
        this.eventService = (EventService)Preconditions.checkNotNull((Object)eventService);
    }

    @Override
    public void handleCrash(Thread thread, Throwable exception) {
        if (!this.mainCrashHandled) {
            this.mainCrashHandled = true;
            Crash crash = Crash.ofThrowable(exception, this.jsException);
            Event.Builder builder = Event.newBuilder().withName(CRASH_REPORT_EVENT_NAME).withType(EmbraceEvent.Type.CRASH).withTimestamp(System.currentTimeMillis()).withAppState(this.metadataService.getAppState()).withActiveEventIds(this.eventService.getActiveEventIds());
            Optional<String> optionalSessionId = this.metadataService.getActiveSessionId();
            if (optionalSessionId.isPresent()) {
                builder.withSessionId((String)optionalSessionId.get());
            }
            EventMessage.Builder versionedEventBuilder = EventMessage.newBuilder().withAppInfo(this.metadataService.getAppInfo()).withDeviceInfo(this.metadataService.getDeviceInfo()).withUserInfo(this.userService.getUserInfo()).withCrash(crash).withEvent(builder.build());
            try {
                this.apiClient.sendEvent(versionedEventBuilder.build()).get();
            }
            catch (Exception ex) {
                EmbraceLogger.logDebug("Failed to report crash to the api", ex);
            }
            this.sessionService.handleCrash(crash.getCrashId());
        }
    }

    private void registerExceptionHandler() {
        Thread.UncaughtExceptionHandler defaultHandler = Thread.getDefaultUncaughtExceptionHandler();
        EmbraceUncaughtExceptionHandler embraceHandler = new EmbraceUncaughtExceptionHandler(defaultHandler, this);
        Thread.setDefaultUncaughtExceptionHandler(embraceHandler);
    }

    @Override
    public void logUnhandledJsException(JsException jsException) {
        this.jsException = jsException;
    }
}

