package io.embrace.android.embracesdk;

import com.google.gson.annotations.SerializedName;

/**
 * Represents performance info for a {@link Session}. This had to be sub-classed, as the API requires
 * the same key, 'nr', be used to represent two completely different objects. In order to overload
 * this key, we need two implementations of the {@link PerformanceInfo}.
 * <p>
 * For a {@link Session} this contains a network timeline.
 */
final class SessionPerformanceInfo extends PerformanceInfo {

    @SerializedName("nr")
    private final NetworkRequests networkRequests;

    private SessionPerformanceInfo(Builder builder) {
        super(builder);
        this.networkRequests = new NetworkRequests(builder.networkSessionV2);
    }

    public static SessionPerformanceInfo.Builder newBuilder() {
        return new SessionPerformanceInfo.Builder();
    }


    static class Builder extends PerformanceInfo.Builder {

        private NetworkSessionV2 networkSessionV2;

        private Builder() {
        }

        public Builder withNetworkSessionV2(NetworkSessionV2 networkSessionV2) {
            this.networkSessionV2 = networkSessionV2;
            return this;
        }

        public SessionPerformanceInfo build() {
            return new SessionPerformanceInfo(this);
        }
    }

    class NetworkRequests {
        @SerializedName("v2")
        private final NetworkSessionV2 networkSessionV2;

        NetworkRequests(NetworkSessionV2 networkSessionV2) {
            this.networkSessionV2 = networkSessionV2;
        }
    }
}
