package io.embrace.android.embracesdk;

/**
 * Generates performance payloads using combined performance metrics from the device, including:
 * <ul>
 *      <li>CPU</li>
 *      <li>Power</li>
 *      <li>ANR intervals</li>
 *      <li>Network calls</li>
 *      <li>Memory usage</li>
 *      <li>Disk usage</li>
 *      <li>Signal strength</li>
 *      <li>Connection quality class</li>
 * </ul>
 */
interface PerformanceInfoService {
    /**
     * Gets the device performance information payload for an event. This is sent only with the
     * following events, because they have a corresponding start event so a time window can
     * be computed for capturing the performance information:
     * <ul>
     * <li>LATE</li>
     * <li>END</li>
     * <li>INTERRUPT</li>
     * </ul>
     *
     * @param startTime the start time of the performance information to retrieve
     * @param endTime   the end time of the performance information to retrieve
     * @return the performance information
     */
    EventPerformanceInfo getPerformanceInfo(long startTime, long endTime);

    /**
     * Gets the device performance information payload to send with the session message. This
     * indicates activity on the device during that particular session, and is used to build a
     * timeline of events. This is like the {@link EventPerformanceInfo}, but contains a timeline
     * of network events, rather than a list of network calls.
     *
     * @param sessionStart the start time of the session
     * @param sessionLastKnownTime the last known time of the session
     * @return the performance information for the session
     */
    SessionPerformanceInfo getSessionPerformanceInfo(long sessionStart, long sessionLastKnownTime);

}
