package io.embrace.android.embracesdk;

import com.google.gson.annotations.SerializedName;

import java.util.Map;

class NativeCrashData {

    @SerializedName("report_id")
    private final String id;

    @SerializedName("sid")
    private final String sessionId;

    @SerializedName("ts")
    private final Long timestamp;

    @SerializedName("state")
    private final String appState;

    @SerializedName("meta")
    private final NativeCrashMetadata metadata;

    @SerializedName("crash")
    private final String crash;

    @SerializedName("symbols")
    private Map<String, String> symbols;

    public NativeCrashData(String id, String sessionId, Long timestamp, String appState, NativeCrashMetadata metadata, String crash, Map<String, String> symbols) {
        this.id = id;
        this.sessionId = sessionId;
        this.timestamp = timestamp;
        this.appState = appState;
        this.metadata = metadata;
        this.crash = crash;
        this.symbols = symbols;
    }

    public void setSymbols(Map<String, String> symbols) {
        this.symbols = symbols;
    }

    public String getNativeCrashId() {
        return id;
    }

    public String getSessionId() {
        return sessionId;
    }

    public Long getTimestamp() {
        return timestamp;
    }

    public String getAppState() {
        return appState;
    }

    public NativeCrashMetadata getMetadata() {
        return metadata;
    }

    public NativeCrash getCrash() {
        return new NativeCrash(id, crash, symbols);
    }

    public Map<String, String> getSymbols() {
        return symbols;
    }

    public static class NativeCrashMetadata {

        @SerializedName("a")
        private final AppInfo appInfo;

        @SerializedName("d")
        private final DeviceInfo deviceInfo;

        NativeCrashMetadata(AppInfo appInfo, DeviceInfo deviceInfo) {
            this.appInfo = appInfo;
            this.deviceInfo = deviceInfo;
        }

        public DeviceInfo getDeviceInfo() {
            return deviceInfo;
        }

        public AppInfo getAppInfo() {
            return appInfo;
        }
    }
}
