package io.embrace.android.embracesdk;

import com.google.gson.annotations.SerializedName;

/**
 * Describes a snapshot of memory usage.
 */
final class MemorySample {
    @SerializedName("ts")
    private final long timestamp;

    @SerializedName("us")
    private final long memoryUsed;

    @SerializedName("fr")
    private final long memoryFree;

    MemorySample(long timestamp, long memoryUsed, long memoryFree) {
        this.timestamp = timestamp;
        this.memoryUsed = memoryUsed;
        this.memoryFree = memoryFree;
    }
}
