package io.embrace.android.embracesdk;

import com.fernandocejas.arrow.checks.Preconditions;
import com.fernandocejas.arrow.optional.Optional;

import java.util.LinkedList;
import java.util.List;

import java9.util.stream.Collectors;
import java9.util.stream.StreamSupport;

final class EmbraceOrientationService implements OrientationService, MemoryCleanerListener {

    /**
     * States the activity orientations.
     */
    private final LinkedList<Orientation> orientations = new LinkedList<>();

    EmbraceOrientationService(MemoryCleanerService memoryCleanerService) {
        Preconditions.checkNotNull(memoryCleanerService).addListener(this);
    }

    @Override
    public void onOrientationChanged(Optional<Integer> orientation) {
        if (orientation.isPresent() && (this.orientations.isEmpty() || this.orientations.getLast().getInternalOrientation() != orientation.get())) {
            this.orientations.add(new Orientation(orientation.get(), System.currentTimeMillis()));
        }
    }

    @Override
    public List<Orientation> getOrientations() {
        return StreamSupport.stream(orientations).collect(Collectors.toList());
    }

    @Override
    public void cleanCollections() {
        orientations.clear();
    }
}
