package io.embrace.android.embracesdk;

import java.util.concurrent.CopyOnWriteArrayList;

import java9.util.stream.StreamSupport;

final class EmbraceMemoryCleanerService implements MemoryCleanerService {

    private static final String ERROR_FAILED_TO_CLEAN = "Failed to clean collections on service listener";

    /**
     * List of listeners that subscribe to clean services collections.
     */
    private final CopyOnWriteArrayList<MemoryCleanerListener> listeners = new CopyOnWriteArrayList<>();

    @Override
    public void cleanServicesCollections() {
        StreamSupport.stream(listeners).forEach(listener -> {
            try {
                listener.cleanCollections();
                Embrace.getInstance().getMetadataService().setActiveSessionId(null);
                Embrace.getInstance().getExceptionsService().resetExceptionErrorObject();
            } catch (Exception ex) {
                EmbraceLogger.logDebug(ERROR_FAILED_TO_CLEAN, ex);
            }
        });
    }

    @Override
    public void addListener(MemoryCleanerListener listener) {
        listeners.addIfAbsent(listener);
    }
}
