package io.embrace.android.embracesdk;

import com.google.gson.annotations.SerializedName;

/**
 * Wraps the event {@link Type}. This class is purely used for backwards-compatibility.
 */
final class EmbraceEvent {
    /**
     * This actually belongs in {@link Event}, but to maintain backwards-compatibility of the API,
     * this enum has been moved here rather than making {@link Event} public.
     */
    public enum Type {
        @SerializedName("start")
        START {
            @Override
            String getAbbreviation() {
                return "s";
            }
        },

        @SerializedName("late")
        LATE {
            @Override
            String getAbbreviation() {
                return "l";
            }
        },

        @SerializedName("interrupt")
        INTERRUPT {
            @Override
            String getAbbreviation() {
                return "i";
            }
        },

        @SerializedName("crash")
        CRASH {
            @Override
            String getAbbreviation() {
                return "c";
            }
        },

        @SerializedName("end")
        END {
            @Override
            String getAbbreviation() {
                return "e";
            }
        },

        @SerializedName("info")
        INFO_LOG {
            @Override
            String getAbbreviation() {
                return "il";
            }
        },

        @SerializedName("error")
        ERROR_LOG {
            @Override
            String getAbbreviation() {
                return "el";
            }
        },

        @SerializedName("warning")
        WARNING_LOG {
            @Override
            String getAbbreviation() {
                return "wl";
            }
        };

        /**
         * Gets the abbreviation used in the story ID header when sending the event to the Embrace
         * API using the {@link ApiClient}.
         *
         * @return the abbreviation for the event type
         */
        abstract String getAbbreviation();
    }

    private EmbraceEvent() {
        // Restricted constructor
    }
}
