package io.embrace.android.embracesdk;

import com.google.gson.annotations.SerializedName;

/**
 * Disk space used by the app and available memory on the device.
 */
final class DiskUsage {
    /** Amount of disk space consumed by the app in bytes. */
    @SerializedName("as")
    private final Long appDiskUsage;

    /** Amount of disk space free on the device in bytes. */
    @SerializedName("fs")
    private final long deviceDiskFree;

    DiskUsage(long appDiskUsage, long deviceDiskFree) {
        this.appDiskUsage = appDiskUsage;
        this.deviceDiskFree = deviceDiskFree;
    }

    DiskUsage(long deviceDiskFree) {
        this.deviceDiskFree = deviceDiskFree;
        this.appDiskUsage = null;
    }
}
