/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.embracesdk.network.http;

import com.fernandocejas.arrow.checks.Preconditions;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;

public class CountingOutputStream
extends FilterOutputStream {
    private long count;
    private byte[] requestBody;

    public CountingOutputStream(OutputStream out) {
        super((OutputStream)Preconditions.checkNotNull((Object)out));
    }

    public long getCount() {
        return this.count;
    }

    byte[] getRequestBody() {
        return this.requestBody;
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.out.write(b, off, len);
        this.count += (long)len;
        this.requestBody = b;
        if (this.requestBody.length > 102400) {
            this.requestBody = Arrays.copyOf(this.requestBody, 102400);
        }
    }

    @Override
    public void write(int b) throws IOException {
        this.out.write(b);
        ++this.count;
    }

    @Override
    public void close() throws IOException {
        this.out.close();
    }
}

