/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.embracesdk;

import android.util.Base64;
import com.google.gson.annotations.SerializedName;
import io.embrace.android.embracesdk.network.NetworkCaptureData;
import java.util.HashMap;
import java.util.Locale;
import java.util.UUID;

class NetworkCaptureCall {
    @SerializedName(value="id")
    private final String networkId;
    @SerializedName(value="sid")
    private final String sessionId;
    @SerializedName(value="st")
    private final Long startTime;
    @SerializedName(value="et")
    private final Long endTime;
    @SerializedName(value="dur")
    private final Long duration;
    @SerializedName(value="mu")
    private final String matchedURL;
    @SerializedName(value="url")
    private final String url;
    @SerializedName(value="m")
    private final String httpMethod;
    @SerializedName(value="sb")
    private final String responseBody;
    @SerializedName(value="sc")
    private final Integer responseStatus;
    @SerializedName(value="sh")
    private final HashMap<String, String> responseHeaders;
    @SerializedName(value="sz")
    private final Integer responseSize;
    @SerializedName(value="si")
    private final Integer responseBodySize;
    @SerializedName(value="qb")
    private final String requestBody;
    @SerializedName(value="qq")
    private final String requestQuery;
    @SerializedName(value="qh")
    private final HashMap<String, String> requestQueryHeaders;
    @SerializedName(value="qz")
    private final Integer requestSize;
    @SerializedName(value="qi")
    private final Integer requestBodySize;

    private NetworkCaptureCall(Builder builder) {
        this.url = builder.url;
        this.httpMethod = builder.httpMethod;
        this.networkId = builder.requestId;
        this.sessionId = builder.sessionId;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
        this.duration = builder.duration;
        this.matchedURL = builder.matchedURL;
        this.responseBody = builder.responseBody;
        this.responseStatus = builder.responseStatus;
        this.responseHeaders = builder.responseHeaders;
        this.responseSize = builder.responseSize;
        this.responseBodySize = builder.responseBodySize;
        this.requestQuery = builder.requestQueryParams;
        this.requestQueryHeaders = builder.requestQueryHeaders;
        this.requestBody = builder.requestBody;
        this.requestSize = builder.requestSize;
        this.requestBodySize = builder.requestBodySize;
    }

    static Builder newBuilder() {
        return new Builder();
    }

    static class Builder {
        private String requestId = Builder.createRequestId();
        private String sessionId;
        private Long startTime;
        private Long endTime;
        private Long duration;
        private String matchedURL;
        private String url;
        private String httpMethod;
        private String responseBody;
        private Integer responseStatus;
        private HashMap<String, String> responseHeaders;
        private Integer responseSize;
        private Integer responseBodySize;
        private String requestQueryParams;
        private HashMap<String, String> requestQueryHeaders;
        private String requestBody;
        private Integer requestSize;
        private Integer requestBodySize;

        private Builder() {
        }

        Builder withUrl(String url) {
            this.url = url;
            return this;
        }

        Builder withHttpMethod(String httpMethod) {
            this.httpMethod = httpMethod;
            return this;
        }

        Builder withSessionId(String sessionId) {
            this.sessionId = sessionId;
            return this;
        }

        Builder withStartTime(long startTime) {
            this.startTime = startTime;
            return this;
        }

        Builder withEndTime(long endTime) {
            this.endTime = endTime;
            return this;
        }

        Builder withDuration(long duration) {
            this.duration = duration;
            return this;
        }

        Builder withMatchedURL(String matchedURL) {
            this.matchedURL = matchedURL;
            return this;
        }

        Builder withResponseStatus(int responseStatus) {
            this.responseStatus = responseStatus;
            return this;
        }

        Builder withNetworkCaptureData(NetworkCaptureData networkCaptureData) {
            this.requestQueryParams = networkCaptureData.getRequestQueryParams();
            this.requestQueryHeaders = (HashMap)networkCaptureData.getRequestHeaders();
            this.requestBody = networkCaptureData.getCapturedRequestBody();
            this.responseHeaders = (HashMap)networkCaptureData.getResponseHeaders();
            this.responseBody = networkCaptureData.getCapturedResponseBody();
            this.requestSize = networkCaptureData.getRequestBodySize();
            this.responseSize = networkCaptureData.getResponseBodySize();
            this.requestBodySize = networkCaptureData.getCapturedRequestBodySize();
            this.responseBodySize = networkCaptureData.getCapturedResponseBodySize();
            return this;
        }

        NetworkCaptureCall build() {
            return new NetworkCaptureCall(this);
        }

        private static String createRequestId() {
            return String.format("%.32s", Base64.encodeToString((byte[])UUID.randomUUID().toString().getBytes(), (int)2).replace('+', '0').replace(' ', '0')).toUpperCase(Locale.getDefault());
        }
    }
}

