/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.embracesdk;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.fernandocejas.arrow.checks.Preconditions;
import io.embrace.android.embracesdk.Clock;
import io.embrace.android.embracesdk.ConfigService;
import io.embrace.android.embracesdk.ConnectionClassService;
import io.embrace.android.embracesdk.Embrace;
import io.embrace.android.embracesdk.EmbraceEvent;
import io.embrace.android.embracesdk.EmbraceLogger;
import io.embrace.android.embracesdk.EmbraceNetworkUtils;
import io.embrace.android.embracesdk.LocalConfig;
import io.embrace.android.embracesdk.MemoryCleanerListener;
import io.embrace.android.embracesdk.MemoryCleanerService;
import io.embrace.android.embracesdk.NetworkCallV2;
import io.embrace.android.embracesdk.NetworkCaptureCall;
import io.embrace.android.embracesdk.NetworkLoggingService;
import io.embrace.android.embracesdk.NetworkSessionV2;
import io.embrace.android.embracesdk.Session;
import io.embrace.android.embracesdk.network.NetworkBodyRule;
import io.embrace.android.embracesdk.network.NetworkCaptureData;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java9.util.J8Arrays;
import java9.util.Optional;
import java9.util.stream.Collectors;
import java9.util.stream.StreamSupport;

class EmbraceNetworkLoggingService
implements NetworkLoggingService,
MemoryCleanerListener {
    public static final String DNS_PATTERN = "([a-zA-Z0-9]([a-zA-Z0-9\\-]{0,63}[a-zA-Z0-9])?)(\\.[a-zA-Z]{1,63})(\\.[a-zA-Z]{1,2})?$";
    public static final String IPV4_PATTERN = "^((25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\.){3}(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)$";
    public static final String IPV6_PATTERN = "(([a-fA-F0-9]{1,4}|):){1,7}([a-fA-F0-9]{1,4}|:)";
    private static final int DEFAULT_NETWORK_CALL_LIMIT = 1000;
    private static final int DEFAULT_NETWORK_CALL_ERROR_STATUS_CODE = 0;
    private final Clock clock;
    private final ConnectionClassService connectionClassService;
    private final ConfigService configService;
    private final LocalConfig localConfig;
    private volatile NetworkBodyRule activeRule;
    private final NavigableMap<Long, NetworkCallV2> networkCalls;
    private final Map<String, DomainSettings> domainSettings;

    public EmbraceNetworkLoggingService(Clock clock, ConnectionClassService connectionClassService, ConfigService configService, LocalConfig localConfig, MemoryCleanerService memoryCleanerService) {
        this.clock = clock;
        this.connectionClassService = (ConnectionClassService)Preconditions.checkNotNull((Object)connectionClassService, (Object)"connectionClassService must not be null");
        this.configService = (ConfigService)Preconditions.checkNotNull((Object)configService, (Object)"configService must not be null");
        this.localConfig = (LocalConfig)Preconditions.checkNotNull((Object)localConfig, (Object)"localConfig must not be null");
        this.networkCalls = new ConcurrentSkipListMap<Long, NetworkCallV2>();
        this.domainSettings = new ConcurrentHashMap<String, DomainSettings>();
        ((MemoryCleanerService)Preconditions.checkNotNull((Object)memoryCleanerService)).addListener(this);
        this.activeRule = null;
    }

    @Override
    public List<NetworkCallV2> getNetworkCalls(long startTime, long endTime) {
        return new ArrayList<NetworkCallV2>(this.networkCalls.subMap(startTime, endTime).values());
    }

    @Override
    public NetworkSessionV2 getNetworkSession(long startTime, long lastKnownTime) {
        List<NetworkCallV2> calls = this.getNetworkCalls(startTime, lastKnownTime);
        com.fernandocejas.arrow.optional.Optional<Integer> gradleLimit = com.fernandocejas.arrow.optional.Optional.absent();
        LocalConfig.SdkConfigs.Networking networkConfig = this.localConfig.getConfigurations().getNetworking();
        if (networkConfig.getDefaultCaptureLimit().isPresent()) {
            gradleLimit = networkConfig.getDefaultCaptureLimit();
        }
        int defaultLimit = (Integer)this.configService.getConfig().getDefaultNetworkCallLimit().or(gradleLimit).or((Object)1000);
        HashMap<String, NetworkSessionV2.DomainCount> callsPerDomain = new HashMap<String, NetworkSessionV2.DomainCount>();
        ArrayList<NetworkCallV2> networkCalls = new ArrayList<NetworkCallV2>();
        int ipAddressCount = 0;
        for (NetworkCallV2 call : calls) {
            com.fernandocejas.arrow.optional.Optional<String> domain = EmbraceNetworkLoggingService.getDomain(call.getUrl());
            if (!domain.isPresent() || EmbraceNetworkLoggingService.isIpAddress((String)domain.get()) && ++ipAddressCount > defaultLimit) continue;
            DomainSettings settings = this.domainSettings.get(domain.get());
            if (settings == null) {
                networkCalls.add(call);
                continue;
            }
            String suffix = settings.getSuffix();
            int limit = settings.getLimit();
            NetworkSessionV2.DomainCount count = (NetworkSessionV2.DomainCount)callsPerDomain.get(suffix);
            if (count == null) {
                count = new NetworkSessionV2.DomainCount(0, limit);
            }
            if (count.getRequestCount() < limit) {
                networkCalls.add(call);
            }
            callsPerDomain.put(suffix, new NetworkSessionV2.DomainCount(count.getRequestCount() + 1, limit));
        }
        HashMap<String, NetworkSessionV2.DomainCount> overLimit = new HashMap<String, NetworkSessionV2.DomainCount>();
        for (Map.Entry entry : callsPerDomain.entrySet()) {
            NetworkSessionV2.DomainCount value = (NetworkSessionV2.DomainCount)entry.getValue();
            if (value.getRequestCount() <= value.getCaptureLimit()) continue;
            overLimit.put((String)entry.getKey(), value);
        }
        return new NetworkSessionV2(networkCalls, overLimit);
    }

    @Override
    public void logNetworkCall(String url, String httpMethod, int statusCode, long startTime, long endTime, long bytesSent, long bytesReceived, String traceId) {
        this.logNetworkCall(url, httpMethod, statusCode, startTime, endTime, bytesSent, bytesReceived, traceId, null);
    }

    @Override
    public void logNetworkCall(String url, String httpMethod, int statusCode, long startTime, long endTime, long bytesSent, long bytesReceived, String traceId, NetworkCaptureData networkCaptureData) {
        long duration = Math.max(endTime - startTime, 0L);
        traceId = EmbraceNetworkUtils.getValidTraceId(traceId);
        NetworkCallV2.Builder networkCallBuilder = NetworkCallV2.newBuilder().withUrl(EmbraceNetworkLoggingService.stripUrl(url)).withHttpMethod(httpMethod).withStartTime(startTime).withDuration(duration).withEndTime(endTime).withBytesSent(bytesSent).withBytesReceived(bytesReceived).withResponseCode(statusCode).withTraceId(traceId);
        NetworkCallV2 networkCall = networkCallBuilder.build();
        if (networkCaptureData != null && this.shouldCaptureNetworkBodyForRule(this.activeRule, url, statusCode)) {
            networkCaptureData.limitBodySize(this.activeRule.getMaxSize());
            this.captureNetworkBody(url, httpMethod, statusCode, startTime, endTime, duration, networkCaptureData);
        }
        this.networkCalls.put(startTime, networkCall);
        this.connectionClassService.logBandwidth(bytesReceived, duration);
        this.storeSettings(url);
    }

    @Override
    public void logNetworkError(String url, String httpMethod, long startTime, long endTime, String errorType, String errorMessage, String traceId) {
        this.logNetworkError(url, httpMethod, startTime, endTime, errorType, errorMessage, traceId, null);
    }

    @Override
    public void logNetworkError(String url, String httpMethod, long startTime, long endTime, String errorType, String errorMessage, String traceId, NetworkCaptureData networkCaptureData) {
        long duration = Math.max(endTime - startTime, 0L);
        traceId = EmbraceNetworkUtils.getValidTraceId(traceId);
        NetworkCallV2.Builder networkCallBuilder = NetworkCallV2.newBuilder().withUrl(EmbraceNetworkLoggingService.stripUrl(url)).withHttpMethod(httpMethod).withStartTime(startTime).withEndTime(endTime).withDuration(duration).withErrorType(errorType).withTraceId(traceId);
        NetworkCallV2 networkCall = networkCallBuilder.build();
        if (networkCaptureData != null && this.shouldCaptureNetworkBodyForRule(this.activeRule, url, 0)) {
            this.captureNetworkBody(url, httpMethod, 0, startTime, endTime, duration, networkCaptureData);
        }
        this.networkCalls.put(startTime, networkCall);
        this.storeSettings(url);
    }

    private void storeSettings(String url) {
        try {
            Map<String, Integer> remoteLimits = this.configService.getConfig().getNetworkCallLimitsPerDomain();
            HashMap<String, Integer> mergedLimits = new HashMap<String, Integer>();
            if (!this.localConfig.getConfigurations().getNetworking().getDomains().isEmpty()) {
                for (LocalConfig.SdkConfigs.Networking.Domain domain : this.localConfig.getConfigurations().getNetworking().getDomains()) {
                    mergedLimits.put(domain.getDomain(), domain.getLimit());
                }
            }
            mergedLimits.putAll(remoteLimits);
            com.fernandocejas.arrow.optional.Optional<String> domain = EmbraceNetworkLoggingService.getDomain(url);
            if (!domain.isPresent()) {
                return;
            }
            String domainString = (String)domain.get();
            if (this.domainSettings.containsKey(domainString)) {
                return;
            }
            for (Map.Entry entry : mergedLimits.entrySet()) {
                if (!domainString.endsWith((String)entry.getKey())) continue;
                this.domainSettings.put(domainString, new DomainSettings((Integer)entry.getValue(), (String)entry.getKey()));
                return;
            }
            int defaultLimit = (Integer)this.configService.getConfig().getDefaultNetworkCallLimit().or((Object)1000);
            this.domainSettings.put(domainString, new DomainSettings(defaultLimit, EmbraceNetworkLoggingService.trimDomain(domainString)));
        }
        catch (Exception ex) {
            EmbraceLogger.logDebug("Failed to determine limits for URL: " + url, ex);
        }
    }

    private static String stripUrl(String url) {
        if (url == null) {
            return null;
        }
        int pathPos = url.lastIndexOf(47);
        String suffix = pathPos < 0 ? url : url.substring(pathPos);
        int queryPos = suffix.indexOf(63);
        int fragmentPos = suffix.indexOf(35);
        int terminalPos = Math.min(queryPos < 0 ? Integer.MAX_VALUE : queryPos, fragmentPos < 0 ? Integer.MAX_VALUE : fragmentPos);
        return url.substring(0, (pathPos < 0 ? 0 : pathPos) + Math.min(suffix.length(), terminalPos));
    }

    @Override
    public void cleanCollections() {
        this.networkCalls.clear();
        this.domainSettings.clear();
    }

    static String trimDomain(String domain) {
        Object[] parts = domain.split(".");
        if (parts.length > 2) {
            return (String)J8Arrays.stream((Object[])parts).skip(1L).collect(Collectors.joining((CharSequence)"."));
        }
        return domain;
    }

    static com.fernandocejas.arrow.optional.Optional<String> getDomain(String url) {
        Matcher matcher;
        if (!url.startsWith("http")) {
            url = String.format("http://%s", url);
        }
        Pattern pattern = Pattern.compile(String.format("%s|%s|%s", DNS_PATTERN, IPV4_PATTERN, IPV6_PATTERN));
        try {
            matcher = pattern.matcher(new URL(url).getHost());
        }
        catch (MalformedURLException ignored) {
            matcher = pattern.matcher(url);
        }
        if (matcher.find()) {
            return com.fernandocejas.arrow.optional.Optional.fromNullable((Object)matcher.group(0));
        }
        return com.fernandocejas.arrow.optional.Optional.absent();
    }

    static boolean isIpAddress(String domain) {
        return Pattern.compile(String.format("%s|%s", IPV4_PATTERN, IPV6_PATTERN)).matcher(domain).find();
    }

    @Nullable
    private String getActiveSessionId() {
        Session session = Embrace.getInstance().getSessionService().getActiveSession();
        if (session != null) {
            return session.getSessionId();
        }
        return null;
    }

    private void captureNetworkBody(String url, String httpMethod, int statusCode, long startTime, long endTime, long duration, NetworkCaptureData networkCaptureData) {
        NetworkCaptureCall capturedNetworkCall = NetworkCaptureCall.newBuilder().withSessionId(this.getActiveSessionId()).withStartTime(startTime).withEndTime(endTime).withDuration(duration).withHttpMethod(httpMethod).withMatchedURL(this.activeRule.getUrlPattern()).withUrl(EmbraceNetworkLoggingService.stripUrl(url)).withResponseStatus(statusCode).withNetworkCaptureData(networkCaptureData).build();
        this.activeRule.updateRemainingCount();
        Embrace.getInstance().getRemoteLogger().logNetwork("Network request log.", EmbraceEvent.Type.NETWORK_LOG, capturedNetworkCall);
        this.configService.updateRuleInConfig(this.activeRule);
    }

    @Override
    public boolean shouldCaptureNetworkBody(@NonNull String url, @NonNull String method) {
        Set<NetworkBodyRule> rules = this.configService.getConfig().getCaptureRules();
        if (rules == null || rules.isEmpty()) {
            return false;
        }
        Optional activeRule = StreamSupport.stream(rules).filter(r -> r.getExpireDate() >= System.currentTimeMillis() && r.getRemainingCount() > 0).filter(r -> r.shouldBeUsedToCapture(url, method)).findFirst();
        if (activeRule.isPresent()) {
            NetworkBodyRule rule = (NetworkBodyRule)activeRule.get();
            if (this.activeRule == null || !this.activeRule.equals(rule)) {
                this.activeRule = (NetworkBodyRule)activeRule.get();
            }
            return true;
        }
        return false;
    }

    private boolean shouldCaptureNetworkBodyForRule(NetworkBodyRule rule, String url, int responseStatus) {
        if (rule == null) {
            EmbraceLogger.logDebug("Ignoring network call capture. The provided rule cannot be null.");
            return false;
        }
        if (url == null || url.isEmpty() || url.equals(this.localConfig.getConfigurations().getBaseUrls().getData())) {
            EmbraceLogger.logDebug("Ignoring network call capture. The url is a base url.");
            return false;
        }
        if (!rule.isStatusCodeCapturable(responseStatus)) {
            EmbraceLogger.logDebug("Ignoring network call capture. The status code is not defined in the provided rule.");
            return false;
        }
        return true;
    }

    class DomainSettings {
        private final int limit;
        private final String suffix;

        DomainSettings(int limit, String suffix) {
            this.limit = limit;
            this.suffix = suffix;
        }

        public int getLimit() {
            return this.limit;
        }

        public String getSuffix() {
            return this.suffix;
        }
    }
}

