/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.embracesdk;

import com.fernandocejas.arrow.checks.Preconditions;
import io.embrace.android.embracesdk.ConnectionClassService;
import io.embrace.android.embracesdk.ConnectionQuality;
import io.embrace.android.embracesdk.ConnectionQualityInterval;
import io.embrace.android.embracesdk.ConnectionQualityListener;
import io.embrace.android.embracesdk.EmbraceLogger;
import io.embrace.android.embracesdk.MemoryCleanerListener;
import io.embrace.android.embracesdk.MemoryCleanerService;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java9.util.stream.StreamSupport;

final class EmbraceConnectionClassService
implements ConnectionClassService,
MemoryCleanerListener {
    private static final int MINIMUM_SAMPLES_THRESHOLD = 2;
    private static final int MINIMUM_SAMPLES_CONNECTION_CHANGE = 5;
    private static final int POOR_BANDWIDTH = 150;
    private static final int MODERATE_BANDWIDTH = 550;
    private static final int GOOD_BANDWIDTH = 2000;
    private static final int MINIMUM_BANDWIDTH = 10;
    private static final long MINIMUM_CONTENT_LENGTH = 5000L;
    private volatile ConnectionQuality connectionQuality = ConnectionQuality.UNKNOWN;
    private volatile int currentBandwidthSampling = 0;
    private volatile int numberOfSamples = 0;
    private final Object lock = new Object();
    private final Set<ConnectionQualityListener> listeners = new CopyOnWriteArraySet<ConnectionQualityListener>();
    private final NavigableMap<Long, ConnectionStat> qualityIntervals = new TreeMap<Long, ConnectionStat>();

    EmbraceConnectionClassService(MemoryCleanerService memoryCleanerService) {
        ((MemoryCleanerService)Preconditions.checkNotNull((Object)memoryCleanerService)).addListener(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void logBandwidth(long bytes, long timeMs) {
        if (bytes < 5000L || timeMs <= 0L) {
            return;
        }
        double bandwidth = (double)bytes * 1.0 / (double)timeMs * 8.0;
        if (bandwidth < 10.0) {
            return;
        }
        Object object = this.lock;
        synchronized (object) {
            boolean initialMeasurement;
            this.currentBandwidthSampling = (int)(((double)(this.currentBandwidthSampling * this.numberOfSamples) + bandwidth) / (double)(this.numberOfSamples + 1));
            ++this.numberOfSamples;
            boolean bl = initialMeasurement = this.connectionQuality == ConnectionQuality.UNKNOWN && this.numberOfSamples == 2;
            if (this.numberOfSamples == 5 || initialMeasurement) {
                ConnectionQuality lastConnectionQuality = this.connectionQuality;
                int currentBandwidth = this.currentBandwidthSampling;
                if (this.currentBandwidthSampling <= 0) {
                    this.connectionQuality = ConnectionQuality.UNKNOWN;
                } else if (this.currentBandwidthSampling < 150) {
                    this.connectionQuality = ConnectionQuality.POOR;
                } else if (this.currentBandwidthSampling < 550) {
                    this.connectionQuality = ConnectionQuality.MODERATE;
                } else if (this.currentBandwidthSampling < 2000) {
                    this.connectionQuality = ConnectionQuality.GOOD;
                } else if (this.currentBandwidthSampling > 2000) {
                    this.connectionQuality = ConnectionQuality.EXCELLENT;
                }
                if (this.numberOfSamples == 5) {
                    this.currentBandwidthSampling = 0;
                    this.numberOfSamples = 0;
                }
                if (this.connectionQuality != lastConnectionQuality) {
                    this.qualityIntervals.put(System.currentTimeMillis(), new ConnectionStat(this.connectionQuality, currentBandwidth));
                    EmbraceLogger.logDebug("Connection quality change to " + (Object)((Object)this.connectionQuality));
                    this.notifyListeners(lastConnectionQuality, this.connectionQuality, currentBandwidth);
                }
            }
        }
    }

    @Override
    public void addListener(ConnectionQualityListener listener) {
        this.listeners.add(listener);
        try {
            listener.onConnectionQualityChange(this.connectionQuality, this.connectionQuality, this.currentBandwidthSampling);
        }
        catch (Exception ex) {
            EmbraceLogger.logDebug("Failed to notify ConnectionQualityListener", ex);
        }
    }

    @Override
    public void removeListener(ConnectionQualityListener listener) {
        this.listeners.remove(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ConnectionQualityInterval> getQualityIntervals(long startTime, long endTime) {
        Object object = this.lock;
        synchronized (object) {
            ArrayList<ConnectionQualityInterval> results = new ArrayList<ConnectionQualityInterval>();
            Map.Entry<Long, ConnectionStat> lastInterval = this.qualityIntervals.floorEntry(startTime);
            if (lastInterval != null) {
                Long nextInterval = this.qualityIntervals.ceilingKey(startTime);
                ConnectionStat stats = lastInterval.getValue();
                results.add(new ConnectionQualityInterval(lastInterval.getKey(), nextInterval != null ? nextInterval : endTime, stats.connectionQuality, stats.bandwidth));
            }
            for (Map.Entry<Long, ConnectionStat> entry : this.qualityIntervals.subMap(startTime, endTime).entrySet()) {
                long currentTime = entry.getKey();
                Long next = this.qualityIntervals.higherKey(currentTime);
                ConnectionStat stats = entry.getValue();
                results.add(new ConnectionQualityInterval(currentTime, next != null ? next : endTime, stats.connectionQuality, stats.bandwidth));
            }
            return results;
        }
    }

    @Override
    public void cleanCollections() {
        this.listeners.clear();
    }

    private void notifyListeners(ConnectionQuality previousQuality, ConnectionQuality newQuality, int bandwidth) {
        StreamSupport.stream(this.listeners).forEach(listener -> {
            try {
                listener.onConnectionQualityChange(previousQuality, newQuality, bandwidth);
            }
            catch (Exception ex) {
                EmbraceLogger.logDebug("Failed to notify ConnectionQualityListener", ex);
            }
        });
    }

    private class ConnectionStat {
        private final ConnectionQuality connectionQuality;
        private final int bandwidth;

        private ConnectionStat(ConnectionQuality connectionQuality, int bandwidth) {
            this.connectionQuality = connectionQuality;
            this.bandwidth = bandwidth;
        }
    }
}

