/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.embracesdk.network.http;

import android.annotation.TargetApi;
import android.os.Build;
import androidx.annotation.Nullable;
import io.embrace.android.embracesdk.Embrace;
import io.embrace.android.embracesdk.EmbraceLogger;
import io.embrace.android.embracesdk.network.NetworkCaptureData;
import io.embrace.android.embracesdk.network.http.CountingInputStreamWithCallback;
import io.embrace.android.embracesdk.network.http.CountingOutputStream;
import io.embrace.android.embracesdk.network.http.EmbraceHttpPathOverride;
import io.embrace.android.embracesdk.network.http.EmbraceHttpUrlConnectionOverride;
import io.embrace.android.embracesdk.network.http.EmbraceSslUrlConnectionService;
import io.embrace.android.embracesdk.network.http.EmbraceUrlConnectionService;
import io.embrace.android.embracesdk.network.http.HttpMethod;
import io.embrace.android.embracesdk.utils.exceptions.Unchecked;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.ProtocolException;
import java.net.URL;
import java.net.URLConnection;
import java.security.Permission;
import java.security.cert.Certificate;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import java9.util.function.Consumer;
import java9.util.stream.StreamSupport;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSocketFactory;

class EmbraceUrlConnectionOverride<T extends HttpURLConnection>
implements EmbraceUrlConnectionService,
EmbraceSslUrlConnectionService {
    private static final String CONTENT_ENCODING = "Content-Encoding";
    private static final String CONTENT_LENGTH = "Content-Length";
    private final T connection;
    private final long createdTime;
    private final boolean enableTransparentGzip;
    private volatile CountingInputStreamWithCallback inputStream;
    private volatile CountingOutputStream outputStream;
    private volatile boolean didLogNetworkCall = false;
    private volatile Long endTime;
    private volatile Long startTime;
    private volatile String traceId;
    private volatile HashMap<String, String> requestHeaders;
    private volatile byte[] capturedResponseBody;

    EmbraceUrlConnectionOverride(T connection, boolean enableTransparentGzip) {
        this.connection = connection;
        this.createdTime = System.currentTimeMillis();
        this.enableTransparentGzip = enableTransparentGzip;
    }

    @Override
    public void addRequestProperty(String key, String value) {
        ((URLConnection)this.connection).addRequestProperty(key, value);
    }

    @Override
    public void connect() throws IOException {
        this.identifyTraceId();
        ((URLConnection)this.connection).connect();
    }

    @Override
    public void disconnect() {
        this.identifyTraceId();
        this.logNetworkCall(this.createdTime, false);
        ((HttpURLConnection)this.connection).disconnect();
    }

    @Override
    public boolean getAllowUserInteraction() {
        return ((URLConnection)this.connection).getAllowUserInteraction();
    }

    @Override
    public void setAllowUserInteraction(boolean allowUserInteraction) {
        ((URLConnection)this.connection).setAllowUserInteraction(allowUserInteraction);
    }

    @Override
    public int getConnectTimeout() {
        return ((URLConnection)this.connection).getConnectTimeout();
    }

    @Override
    public void setConnectTimeout(int timeout) {
        ((URLConnection)this.connection).setConnectTimeout(timeout);
    }

    @Override
    public Object getContent() throws IOException {
        this.identifyTraceId();
        return ((URLConnection)this.connection).getContent();
    }

    @Override
    public Object getContent(Class[] classes) throws IOException {
        this.identifyTraceId();
        return ((URLConnection)this.connection).getContent(classes);
    }

    @Override
    public String getContentEncoding() {
        return this.shouldUncompressGzip() ? null : ((URLConnection)this.connection).getContentEncoding();
    }

    @Override
    public int getContentLength() {
        return this.shouldUncompressGzip() ? -1 : ((URLConnection)this.connection).getContentLength();
    }

    @Override
    @TargetApi(value=24)
    public long getContentLengthLong() {
        return this.shouldUncompressGzip() || Build.VERSION.SDK_INT < 24 ? -1L : ((URLConnection)this.connection).getContentLengthLong();
    }

    @Override
    public String getContentType() {
        return ((URLConnection)this.connection).getContentType();
    }

    @Override
    public long getDate() {
        return ((URLConnection)this.connection).getDate();
    }

    @Override
    public boolean getDefaultUseCaches() {
        return ((URLConnection)this.connection).getDefaultUseCaches();
    }

    @Override
    public void setDefaultUseCaches(boolean defaultUseCaches) {
        ((URLConnection)this.connection).setDefaultUseCaches(defaultUseCaches);
    }

    @Override
    public boolean getDoInput() {
        return ((URLConnection)this.connection).getDoInput();
    }

    @Override
    public void setDoInput(boolean doInput) {
        ((URLConnection)this.connection).setDoInput(doInput);
    }

    @Override
    public boolean getDoOutput() {
        return ((URLConnection)this.connection).getDoOutput();
    }

    @Override
    public void setDoOutput(boolean doOutput) {
        ((URLConnection)this.connection).setDoOutput(doOutput);
    }

    @Override
    public InputStream getErrorStream() {
        this.inputStream = this.countingInputStream(new BufferedInputStream(((HttpURLConnection)this.connection).getErrorStream()));
        return this.getWrappedInputStream();
    }

    @Override
    public long getExpiration() {
        return ((URLConnection)this.connection).getExpiration();
    }

    @Override
    public String getHeaderField(int n) {
        long startTime = System.currentTimeMillis();
        String key = ((HttpURLConnection)this.connection).getHeaderFieldKey(n);
        if (key != null && this.shouldUncompressGzip() && (key.equals(CONTENT_ENCODING) || key.equals(CONTENT_LENGTH))) {
            return null;
        }
        String headerField = ((HttpURLConnection)this.connection).getHeaderField(n);
        this.logNetworkCall(startTime, false);
        return headerField;
    }

    @Override
    public String getHeaderField(String name) {
        if (name == null) {
            return null;
        }
        long startTime = System.currentTimeMillis();
        if (this.shouldUncompressGzip() && (name.equals(CONTENT_ENCODING) || name.equals(CONTENT_LENGTH))) {
            return null;
        }
        String headerField = ((URLConnection)this.connection).getHeaderField(name);
        this.logNetworkCall(startTime, false);
        return headerField;
    }

    @Override
    public long getHeaderFieldDate(String name, long defaultValue) {
        long startTime = System.currentTimeMillis();
        if (name != null && this.shouldUncompressGzip() && (name.equals(CONTENT_ENCODING) || name.equals(CONTENT_LENGTH))) {
            return defaultValue;
        }
        long result = ((HttpURLConnection)this.connection).getHeaderFieldDate(name, defaultValue);
        this.logNetworkCall(startTime, false);
        return result;
    }

    @Override
    public int getHeaderFieldInt(String name, int defaultValue) {
        long startTime = System.currentTimeMillis();
        if (name != null && this.shouldUncompressGzip() && (name.equals(CONTENT_ENCODING) || name.equals(CONTENT_LENGTH))) {
            return defaultValue;
        }
        int result = ((URLConnection)this.connection).getHeaderFieldInt(name, defaultValue);
        this.logNetworkCall(startTime, false);
        return result;
    }

    @Override
    public String getHeaderFieldKey(int n) {
        long startTime = System.currentTimeMillis();
        String headerFieldKey = ((HttpURLConnection)this.connection).getHeaderFieldKey(n);
        if (headerFieldKey != null && this.shouldUncompressGzip() && (headerFieldKey.equals(CONTENT_ENCODING) || headerFieldKey.equals(CONTENT_LENGTH))) {
            return null;
        }
        this.logNetworkCall(startTime, false);
        return headerFieldKey;
    }

    @Override
    @TargetApi(value=24)
    public long getHeaderFieldLong(String name, long defaultValue) {
        long startTime = System.currentTimeMillis();
        if (name != null && this.shouldUncompressGzip() && (name.equals(CONTENT_ENCODING) || name.equals(CONTENT_LENGTH))) {
            return defaultValue;
        }
        long result = Build.VERSION.SDK_INT < 24 ? -1L : ((URLConnection)this.connection).getHeaderFieldLong(name, defaultValue);
        this.logNetworkCall(startTime, false);
        return result;
    }

    @Override
    public Map<String, List<String>> getHeaderFields() {
        long startTime = System.currentTimeMillis();
        Map<String, List<String>> headerFields = ((URLConnection)this.connection).getHeaderFields();
        HashMap<String, List<String>> copy = new HashMap<String, List<String>>(headerFields);
        copy.remove(CONTENT_ENCODING);
        copy.remove(CONTENT_LENGTH);
        this.logNetworkCall(startTime, false);
        return copy;
    }

    @Override
    public long getIfModifiedSince() {
        return ((URLConnection)this.connection).getIfModifiedSince();
    }

    @Override
    public void setIfModifiedSince(long ifModifiedSince) {
        ((URLConnection)this.connection).setIfModifiedSince(ifModifiedSince);
    }

    @Override
    public InputStream getInputStream() throws IOException {
        this.inputStream = this.countingInputStream(new BufferedInputStream(((URLConnection)this.connection).getInputStream()));
        return this.getWrappedInputStream();
    }

    @Override
    public boolean getInstanceFollowRedirects() {
        return ((HttpURLConnection)this.connection).getInstanceFollowRedirects();
    }

    @Override
    public void setInstanceFollowRedirects(boolean followRedirects) {
        ((HttpURLConnection)this.connection).setInstanceFollowRedirects(followRedirects);
    }

    @Override
    public long getLastModified() {
        return ((URLConnection)this.connection).getLastModified();
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        this.identifyTraceId();
        if (this.outputStream == null && ((URLConnection)this.connection).getOutputStream() != null) {
            this.outputStream = new CountingOutputStream(((URLConnection)this.connection).getOutputStream());
        }
        return this.outputStream;
    }

    @Override
    public Permission getPermission() throws IOException {
        return ((HttpURLConnection)this.connection).getPermission();
    }

    @Override
    public int getReadTimeout() {
        return ((URLConnection)this.connection).getReadTimeout();
    }

    @Override
    public void setReadTimeout(int timeout) {
        ((URLConnection)this.connection).setReadTimeout(timeout);
    }

    @Override
    public String getRequestMethod() {
        return ((HttpURLConnection)this.connection).getRequestMethod();
    }

    @Override
    public void setRequestMethod(String method) throws ProtocolException {
        ((HttpURLConnection)this.connection).setRequestMethod(method);
    }

    @Override
    public Map<String, List<String>> getRequestProperties() {
        return ((URLConnection)this.connection).getRequestProperties();
    }

    @Override
    public String getRequestProperty(String key) {
        return ((URLConnection)this.connection).getRequestProperty(key);
    }

    @Override
    public int getResponseCode() throws IOException {
        this.identifyTraceId();
        long startTime = System.currentTimeMillis();
        this.logNetworkCall(startTime, false);
        return ((HttpURLConnection)this.connection).getResponseCode();
    }

    @Override
    public String getResponseMessage() throws IOException {
        this.identifyTraceId();
        long startTime = System.currentTimeMillis();
        this.logNetworkCall(startTime, false);
        return ((HttpURLConnection)this.connection).getResponseMessage();
    }

    @Override
    public URL getURL() {
        return ((URLConnection)this.connection).getURL();
    }

    @Override
    public boolean getUseCaches() {
        return ((URLConnection)this.connection).getUseCaches();
    }

    @Override
    public void setUseCaches(boolean useCaches) {
        ((URLConnection)this.connection).setUseCaches(useCaches);
    }

    @Override
    public void setChunkedStreamingMode(int chunkLen) {
        ((HttpURLConnection)this.connection).setChunkedStreamingMode(chunkLen);
    }

    @Override
    public void setFixedLengthStreamingMode(int contentLength) {
        ((HttpURLConnection)this.connection).setFixedLengthStreamingMode(contentLength);
    }

    @Override
    @TargetApi(value=19)
    public void setFixedLengthStreamingMode(long contentLength) {
        if (Build.VERSION.SDK_INT >= 19) {
            ((HttpURLConnection)this.connection).setFixedLengthStreamingMode(contentLength);
        }
    }

    @Override
    public void setRequestProperty(String key, String value) {
        ((URLConnection)this.connection).setRequestProperty(key, value);
        if (this.hasNetworkCaptureRules()) {
            this.requestHeaders = this.getProcessedHeaders(this.getRequestProperties());
        }
    }

    @Override
    public String toString() {
        return ((URLConnection)this.connection).toString();
    }

    @Override
    public boolean usingProxy() {
        return ((HttpURLConnection)this.connection).usingProxy();
    }

    @Override
    @Nullable
    public String getCipherSuite() {
        if (this.connection instanceof HttpsURLConnection) {
            return ((HttpsURLConnection)this.connection).getCipherSuite();
        }
        return null;
    }

    @Override
    public Certificate[] getLocalCertificates() {
        if (this.connection instanceof HttpsURLConnection) {
            return ((HttpsURLConnection)this.connection).getLocalCertificates();
        }
        return new Certificate[0];
    }

    @Override
    public Certificate[] getServerCertificates() throws SSLPeerUnverifiedException {
        if (this.connection instanceof HttpsURLConnection) {
            return ((HttpsURLConnection)this.connection).getServerCertificates();
        }
        return new Certificate[0];
    }

    @Override
    public SSLSocketFactory getSSLSocketFactory() {
        if (this.connection instanceof HttpsURLConnection) {
            return ((HttpsURLConnection)this.connection).getSSLSocketFactory();
        }
        return null;
    }

    @Override
    public void setSSLSocketFactory(SSLSocketFactory factory) {
        if (this.connection instanceof HttpsURLConnection) {
            ((HttpsURLConnection)this.connection).setSSLSocketFactory(factory);
        }
    }

    @Override
    public HostnameVerifier getHostnameVerifier() {
        if (this.connection instanceof HttpsURLConnection) {
            return ((HttpsURLConnection)this.connection).getHostnameVerifier();
        }
        return null;
    }

    @Override
    public void setHostnameVerifier(HostnameVerifier verifier) {
        if (this.connection instanceof HttpsURLConnection) {
            ((HttpsURLConnection)this.connection).setHostnameVerifier(verifier);
        }
    }

    synchronized void logNetworkCall(long startTime, boolean shouldCaptureBody) {
        this.logNetworkCall(startTime, System.currentTimeMillis(), false, null, shouldCaptureBody);
    }

    synchronized void logNetworkCall(long startTime, long endTime, boolean overwrite, Long bytesIn, boolean shouldCaptureBody) {
        if (!this.didLogNetworkCall || overwrite) {
            this.didLogNetworkCall = true;
            this.startTime = startTime;
            this.endTime = endTime;
            this.identifyTraceId();
            String url = EmbraceHttpPathOverride.getURLString(new EmbraceHttpUrlConnectionOverride((HttpURLConnection)this.connection));
            NetworkCaptureData networkCaptureData = null;
            if (this.hasNetworkCaptureRules() && shouldCaptureBody) {
                networkCaptureData = new NetworkCaptureData().withRequestQueryParams(((URLConnection)this.connection).getURL().getQuery());
                networkCaptureData.withRequestHeaders(this.requestHeaders);
                if (this.outputStream != null) {
                    networkCaptureData.withRequestBody(this.outputStream.getRequestBody());
                }
                if (this.inputStream != null) {
                    networkCaptureData.withResponseHeaders(this.getProcessedHeaders(this.getHeaderFields())).withResponseBody(this.capturedResponseBody);
                }
                if (this.requestHeaders != null) {
                    networkCaptureData.withRequestHeaders(this.requestHeaders);
                }
            }
            try {
                long bytesOut = this.outputStream == null ? 0L : Math.max(this.outputStream.getCount(), 0L);
                long contentLength = bytesIn == null ? (long)Math.max(((URLConnection)this.connection).getContentLength(), 0) : bytesIn;
                Embrace.getInstance().logNetworkCall(url, HttpMethod.fromString(this.getRequestMethod()), this.getResponseCode(), startTime, endTime, bytesOut, contentLength, this.traceId, networkCaptureData);
            }
            catch (Exception e) {
                Embrace.getInstance().logNetworkClientError(url, HttpMethod.fromString(this.getRequestMethod()), startTime, endTime, e.getClass().getCanonicalName(), e.getMessage(), this.traceId, networkCaptureData);
            }
        }
    }

    private CountingInputStreamWithCallback countingInputStream(InputStream inputStream) {
        return new CountingInputStreamWithCallback(inputStream, this.hasNetworkCaptureRules(), (Consumer<Long>)((Consumer)bytes -> {
            if (this.startTime != null && this.endTime != null) {
                this.logNetworkCall(this.startTime, this.endTime, true, (Long)bytes, true);
            }
        }), (Consumer<byte[]>)((Consumer)body -> {
            this.capturedResponseBody = body;
        }));
    }

    private boolean shouldUncompressGzip() {
        String contentEncoding = ((URLConnection)this.connection).getContentEncoding();
        return this.enableTransparentGzip && contentEncoding != null && contentEncoding.equalsIgnoreCase("gzip");
    }

    private void identifyTraceId() {
        if (this.traceId == null) {
            try {
                this.traceId = this.getRequestProperty(Embrace.getInstance().getTraceIdHeader());
            }
            catch (Exception e) {
                EmbraceLogger.logDebug("Failed to retrieve actual trace id header. Current: " + this.traceId);
            }
        }
    }

    private HashMap<String, String> getProcessedHeaders(Map<String, List<String>> properties) {
        HashMap<String, String> headers = new HashMap<String, String>();
        StreamSupport.stream(properties.entrySet()).forEach(h -> {
            StringBuilder builder = new StringBuilder();
            for (String value : (List)h.getValue()) {
                if (value == null) continue;
                builder.append(value);
            }
            headers.put((String)h.getKey(), builder.toString());
        });
        return headers;
    }

    private boolean hasNetworkCaptureRules() {
        if (((URLConnection)this.connection).getURL() == null) {
            return false;
        }
        String url = ((URLConnection)this.connection).getURL().toString();
        String method = ((HttpURLConnection)this.connection).getRequestMethod();
        return Embrace.getInstance().shouldCaptureNetworkBody(url, method);
    }

    private InputStream getWrappedInputStream() {
        InputStream in;
        long startTime = System.currentTimeMillis();
        this.identifyTraceId();
        if (this.inputStream != null) {
            if (this.shouldUncompressGzip()) {
                try {
                    in = Unchecked.wrap(() -> new GZIPInputStream(this.inputStream));
                }
                catch (Exception e) {
                    in = this.inputStream;
                }
            } else {
                in = this.inputStream;
            }
        } else {
            in = null;
        }
        this.logNetworkCall(startTime, false);
        return in;
    }
}

