/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.embracesdk;

import android.content.Context;
import android.content.res.Resources;
import com.fernandocejas.arrow.optional.Optional;

final class BuildInfo {
    private static final String BUILD_INFO_BUILD_ID = "emb_build_id";
    private static final String BUILD_INFO_BUILD_TYPE = "emb_build_type";
    private static final String BUILD_INFO_BUILD_FLAVOR = "emb_build_flavor";
    private final String buildId;
    private final String buildType;
    private final String buildFlavor;

    BuildInfo(String buildId, String buildType, String buildFlavor) {
        this.buildId = buildId;
        this.buildType = buildType;
        this.buildFlavor = (String)Optional.fromNullable((Object)buildFlavor).orNull();
    }

    static BuildInfo fromResources(Context context) {
        try {
            int buildFlavorId = BuildInfo.getResourcesIdentifier(context, BUILD_INFO_BUILD_FLAVOR, "string");
            return new BuildInfo(context.getResources().getString(BuildInfo.getResourcesIdentifier(context, BUILD_INFO_BUILD_ID, "string")), context.getResources().getString(BuildInfo.getResourcesIdentifier(context, BUILD_INFO_BUILD_TYPE, "string")), buildFlavorId != 0 ? context.getResources().getString(buildFlavorId) : null);
        }
        catch (Exception ex) {
            throw new RuntimeException("Failed to read build_info.xml", ex);
        }
    }

    private static int getResourcesIdentifier(Context context, String buildProperty, String type) {
        Resources resources = context.getResources();
        return resources.getIdentifier(buildProperty, type, context.getPackageName());
    }

    String getBuildId() {
        return this.buildId;
    }

    String getBuildType() {
        return this.buildType;
    }

    String getBuildFlavor() {
        return this.buildFlavor;
    }
}

