package io.embrace.android.embracesdk.network.http;

import android.annotation.TargetApi;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ProtocolException;
import java.net.URL;
import java.security.Permission;
import java.util.List;
import java.util.Map;

public interface EmbraceUrlConnectionService {

    void addRequestProperty(String key, String value);

    void connect() throws IOException;

    void disconnect();

    boolean getAllowUserInteraction();

    void setAllowUserInteraction(boolean allowUserInteraction);

    int getConnectTimeout();

    void setConnectTimeout(int timeout);

    Object getContent() throws IOException;

    Object getContent(Class[] classes) throws IOException;

    String getContentEncoding();

    int getContentLength();

    @TargetApi(24)
    long getContentLengthLong();

    String getContentType();

    long getDate();

    boolean getDefaultUseCaches();

    void setDefaultUseCaches(boolean defaultUseCaches);

    boolean getDoInput();

    void setDoInput(boolean doInput);

    boolean getDoOutput();

    void setDoOutput(boolean doOutput);

    InputStream getErrorStream();

    long getExpiration();

    String getHeaderField(int n);

    String getHeaderField(String name);

    long getHeaderFieldDate(String name, long defaultValue);

    int getHeaderFieldInt(String name, int defaultValue);

    String getHeaderFieldKey(int n);

    @TargetApi(24)
    long getHeaderFieldLong(String name, long defaultValue);

    Map<String, List<String>> getHeaderFields();

    long getIfModifiedSince();

    void setIfModifiedSince(long ifModifiedSince);

    InputStream getInputStream() throws IOException;

    boolean getInstanceFollowRedirects();

    void setInstanceFollowRedirects(boolean followRedirects);

    long getLastModified();

    OutputStream getOutputStream() throws IOException;

    Permission getPermission() throws IOException;

    int getReadTimeout();

    void setReadTimeout(int timeout);

    String getRequestMethod();

    void setRequestMethod(String method) throws ProtocolException;

    Map<String, List<String>> getRequestProperties();

    String getRequestProperty(String key);

    int getResponseCode() throws IOException;

    String getResponseMessage() throws IOException;

    URL getURL();

    boolean getUseCaches();

    void setUseCaches(boolean useCaches);

    void setChunkedStreamingMode(int chunkLen);

    void setFixedLengthStreamingMode(int contentLength);

    @TargetApi(19)
    void setFixedLengthStreamingMode(long contentLength);

    void setRequestProperty(String key, String value);

    String toString();

    boolean usingProxy();
}
