/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.embracesdk.network.http;

import com.fernandocejas.arrow.checks.Preconditions;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java9.util.function.Consumer;

final class CountingInputStreamWithCallback
extends FilterInputStream {
    private volatile long streamMark = -1L;
    private final Consumer<Long> callback;
    private final Consumer<byte[]> capturedBodyCallback;
    private volatile boolean callbackCompleted;
    private long count;
    private volatile boolean shouldCaptureBody;

    CountingInputStreamWithCallback(InputStream in, boolean shouldCaptureBody, Consumer<Long> callback, Consumer<byte[]> capturedBodyCallback) {
        super((InputStream)Preconditions.checkNotNull((Object)in));
        this.callback = (Consumer)Preconditions.checkNotNull(callback);
        this.capturedBodyCallback = (Consumer)Preconditions.checkNotNull(capturedBodyCallback);
        this.shouldCaptureBody = shouldCaptureBody;
    }

    long getCount() {
        return this.count;
    }

    @Override
    public int read() throws IOException {
        int result = this.in.read();
        if (result != -1) {
            ++this.count;
        } else if (!this.callbackCompleted) {
            this.callbackCompleted = true;
            this.callback.accept((Object)this.count);
        }
        return result;
    }

    @Override
    public int read(byte[] b) throws IOException {
        int result = super.read(b);
        if (result != -1) {
            this.conditionallyCaptureBody(b);
        }
        return result;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int result = this.in.read(b, off, len);
        if (result != -1) {
            this.count += (long)result;
            this.conditionallyCaptureBody(b);
        } else if (!this.callbackCompleted) {
            this.callbackCompleted = true;
            this.callback.accept((Object)this.count);
        }
        return result;
    }

    @Override
    public long skip(long n) throws IOException {
        long result = this.in.skip(n);
        this.count += result;
        return result;
    }

    @Override
    public synchronized void mark(int readlimit) {
        this.in.mark(readlimit);
        this.streamMark = this.count;
    }

    @Override
    public synchronized void reset() throws IOException {
        if (!this.in.markSupported()) {
            throw new IOException("Mark not supported");
        }
        if (this.streamMark == -1L) {
            throw new IOException("Mark not set");
        }
        this.in.reset();
        this.count = this.streamMark;
        this.callbackCompleted = false;
    }

    private synchronized void conditionallyCaptureBody(byte[] body) {
        if (!this.shouldCaptureBody) {
            return;
        }
        this.capturedBodyCallback.accept((Object)body);
    }
}

