/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.embracesdk.network;

import android.util.Base64;
import androidx.annotation.Nullable;
import io.embrace.android.embracesdk.EmbraceLogger;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public class NetworkCaptureData {
    private volatile HashMap<String, String> requestHeaders;
    private volatile String requestQueryParams;
    private int requestBodyLength;
    private String capturedRequestBody;
    private volatile HashMap<String, String> responseHeaders;
    private int responseBodyLength;
    private String capturedResponseBody;

    public NetworkCaptureData withRequestHeaders(Map<String, String> requestHeaders) {
        this.requestHeaders = (HashMap)requestHeaders;
        return this;
    }

    public NetworkCaptureData withResponseHeaders(Map<String, String> responseHeaders) {
        this.responseHeaders = (HashMap)responseHeaders;
        return this;
    }

    public NetworkCaptureData withRequestQueryParams(String requestQueryParams) {
        this.requestQueryParams = requestQueryParams;
        return this;
    }

    public NetworkCaptureData withRequestBody(byte[] requestBody) {
        this.requestBodyLength = requestBody != null ? requestBody.length : 0;
        this.capturedRequestBody = this.parseBody(requestBody);
        return this;
    }

    public NetworkCaptureData withResponseBody(byte[] responseBody) {
        this.responseBodyLength = responseBody != null ? responseBody.length : 0;
        this.capturedResponseBody = this.parseBody(responseBody);
        return this;
    }

    @Nullable
    public Map<String, String> getRequestHeaders() {
        return this.requestHeaders;
    }

    public String getRequestQueryParams() {
        return this.requestQueryParams;
    }

    public String getCapturedRequestBody() {
        return this.capturedRequestBody;
    }

    public Integer getCapturedRequestBodySize() {
        return this.capturedRequestBody != null ? this.capturedRequestBody.length() : 0;
    }

    public Integer getRequestBodySize() {
        return this.requestBodyLength;
    }

    @Nullable
    public Map<String, String> getResponseHeaders() {
        return this.responseHeaders;
    }

    public String getCapturedResponseBody() {
        return this.capturedResponseBody;
    }

    public Integer getCapturedResponseBodySize() {
        return this.capturedResponseBody != null ? this.capturedResponseBody.length() : 0;
    }

    public Integer getResponseBodySize() {
        return this.responseBodyLength;
    }

    public void limitBodySize(int size) {
        if (size != 0 && this.capturedRequestBody != null && this.capturedRequestBody.length() > size) {
            this.capturedRequestBody = this.capturedRequestBody.substring(0, size);
        }
        if (size != 0 && this.capturedResponseBody != null && this.capturedResponseBody.length() > size) {
            this.capturedResponseBody = this.capturedResponseBody.substring(0, size);
        }
    }

    @Nullable
    private String parseBody(@Nullable byte[] body) {
        if (body == null) {
            return null;
        }
        try {
            if (body.length > 102400) {
                body = Arrays.copyOf(body, 102400);
            }
            return Base64.encodeToString((byte[])body, (int)2);
        }
        catch (Exception e) {
            EmbraceLogger.logDebug("Parsing body failed.", e);
            return null;
        }
    }
}

