/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.embracesdk;

import com.google.gson.annotations.SerializedName;

class NetworkCallV2 {
    @SerializedName(value="bi")
    private final long bytesReceived;
    @SerializedName(value="bo")
    private final long bytesSent;
    @SerializedName(value="dur")
    private final long duration;
    @SerializedName(value="ed")
    private final String errorType;
    @SerializedName(value="et")
    private final long endTime;
    @SerializedName(value="rc")
    private final int responseCode;
    @SerializedName(value="url")
    private final String url;
    @SerializedName(value="st")
    private final long startTime;
    @SerializedName(value="x")
    private final String httpMethod;
    @SerializedName(value="t")
    private final String traceId;

    private NetworkCallV2(Builder builder) {
        this.bytesReceived = builder.bytesReceived;
        this.bytesSent = builder.bytesSent;
        this.duration = builder.duration;
        this.errorType = builder.errorType;
        this.endTime = builder.endTime;
        this.responseCode = builder.responseCode;
        this.url = builder.url;
        this.startTime = builder.startTime;
        this.httpMethod = builder.httpMethod;
        this.traceId = builder.traceId;
    }

    public long getBytesReceived() {
        return this.bytesReceived;
    }

    public long getBytesSent() {
        return this.bytesSent;
    }

    public long getDuration() {
        return this.duration;
    }

    public String getErrorType() {
        return this.errorType;
    }

    public long getEndTime() {
        return this.endTime;
    }

    public int getResponseCode() {
        return this.responseCode;
    }

    public String getUrl() {
        return this.url;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public String getHttpMethod() {
        return this.httpMethod;
    }

    public String getTraceId() {
        return this.traceId;
    }

    static Builder newBuilder() {
        return new Builder();
    }

    static class Builder {
        private long bytesReceived;
        private long bytesSent;
        private long duration;
        private String errorType;
        private long endTime;
        private int responseCode;
        private String url;
        private long startTime;
        private String httpMethod;
        private String traceId;

        private Builder() {
        }

        Builder withBytesReceived(long bytesReceived) {
            this.bytesReceived = bytesReceived;
            return this;
        }

        Builder withBytesSent(long bytesSent) {
            this.bytesSent = bytesSent;
            return this;
        }

        Builder withDuration(long duration) {
            this.duration = duration;
            return this;
        }

        Builder withErrorType(String errorType) {
            this.errorType = errorType;
            return this;
        }

        Builder withEndTime(long endTime) {
            this.endTime = endTime;
            return this;
        }

        Builder withResponseCode(int responseCode) {
            this.responseCode = responseCode;
            return this;
        }

        Builder withUrl(String url) {
            this.url = url;
            return this;
        }

        Builder withStartTime(long startTime) {
            this.startTime = startTime;
            return this;
        }

        Builder withHttpMethod(String httpMethod) {
            this.httpMethod = httpMethod;
            return this;
        }

        Builder withTraceId(String traceId) {
            this.traceId = traceId;
            return this;
        }

        NetworkCallV2 build() {
            return new NetworkCallV2(this);
        }
    }
}

