/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.embracesdk;

import android.app.Activity;
import android.app.Application;
import android.content.ComponentCallbacks;
import android.content.res.Configuration;
import android.os.Bundle;
import androidx.lifecycle.Lifecycle;
import androidx.lifecycle.LifecycleObserver;
import androidx.lifecycle.OnLifecycleEvent;
import androidx.lifecycle.ProcessLifecycleOwner;
import com.fernandocejas.arrow.checks.Preconditions;
import com.fernandocejas.arrow.optional.Optional;
import io.embrace.android.embracesdk.ActivityListener;
import io.embrace.android.embracesdk.ActivityService;
import io.embrace.android.embracesdk.EmbraceLogger;
import io.embrace.android.embracesdk.MemoryService;
import io.embrace.android.embracesdk.OrientationService;
import io.embrace.android.embracesdk.ScheduledWorker;
import io.embrace.android.embracesdk.annotation.StartupActivity;
import java.lang.ref.WeakReference;
import java.util.concurrent.CopyOnWriteArrayList;
import java9.util.stream.StreamSupport;

final class EmbraceActivityService
implements ActivityService {
    private static final String ERROR_FAILED_TO_NOTIFY = "Failed to notify EmbraceActivityService listener";
    private final ScheduledWorker appStateWorker = ScheduledWorker.ofSingleThread("App state service");
    private final MemoryService memoryService;
    private volatile OrientationService orientationService;
    private final CopyOnWriteArrayList<ActivityListener> listeners = new CopyOnWriteArrayList();
    private final Application application;
    private volatile WeakReference<Activity> currentActivity = new WeakReference<Object>(null);
    private volatile boolean coldStart = true;
    private volatile long startTime;
    private volatile boolean isInBackground = false;

    EmbraceActivityService(Application application, MemoryService memoryService, OrientationService orientationService) {
        this.memoryService = (MemoryService)Preconditions.checkNotNull((Object)memoryService);
        this.orientationService = (OrientationService)Preconditions.checkNotNull((Object)orientationService);
        this.application = (Application)Preconditions.checkNotNull((Object)application);
        this.startTime = System.currentTimeMillis();
        application.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this);
        application.getApplicationContext().registerComponentCallbacks((ComponentCallbacks)this);
        ProcessLifecycleOwner.get().getLifecycle().addObserver((LifecycleObserver)this);
    }

    public void onActivityCreated(Activity activity, Bundle bundle) {
        this.updateStateWithActivity(activity);
        this.updateOrientationWithActivity(activity);
    }

    public void onActivityStarted(Activity activity) {
        this.updateStateWithActivity(activity);
        StreamSupport.stream(this.listeners).forEach(listener -> {
            try {
                listener.onView(activity);
            }
            catch (Exception ex) {
                EmbraceLogger.logDebug(ERROR_FAILED_TO_NOTIFY, ex);
            }
        });
    }

    public void onActivityResumed(Activity activity) {
        if (!activity.getClass().isAnnotationPresent(StartupActivity.class)) {
            StreamSupport.stream(this.listeners).forEach(listener -> {
                try {
                    listener.applicationStartupComplete();
                }
                catch (Exception ex) {
                    EmbraceLogger.logDebug(ERROR_FAILED_TO_NOTIFY, ex);
                }
            });
        }
    }

    public void onActivityPaused(Activity activity) {
    }

    public void onActivityStopped(Activity activity) {
        StreamSupport.stream(this.listeners).forEach(listener -> {
            try {
                listener.onViewClose(activity);
            }
            catch (Exception ex) {
                EmbraceLogger.logDebug(ERROR_FAILED_TO_NOTIFY, ex);
            }
        });
    }

    public void onActivitySaveInstanceState(Activity activity, Bundle bundle) {
    }

    public void onActivityDestroyed(Activity activity) {
    }

    private synchronized void updateStateWithActivity(Activity activity) {
        this.currentActivity = new WeakReference<Activity>(activity);
    }

    private void updateOrientationWithActivity(Activity activity) {
        try {
            this.orientationService.onOrientationChanged((Optional<Integer>)Optional.of((Object)activity.getResources().getConfiguration().orientation));
        }
        catch (Exception ex) {
            EmbraceLogger.logDebug("Failed to register an orientation change", ex);
        }
    }

    @OnLifecycleEvent(value=Lifecycle.Event.ON_START)
    void onForeground() {
        EmbraceLogger.logDebug("AppState: App entered foreground.");
        this.isInBackground = false;
        StreamSupport.stream(this.listeners).forEach(listener -> {
            try {
                listener.onForeground(this.coldStart, this.startTime);
            }
            catch (Exception ex) {
                EmbraceLogger.logDebug(ERROR_FAILED_TO_NOTIFY, ex);
            }
        });
        this.coldStart = false;
    }

    @OnLifecycleEvent(value=Lifecycle.Event.ON_STOP)
    void onBackground() {
        EmbraceLogger.logDebug("AppState: App entered background");
        this.updateStateWithActivity(null);
        this.isInBackground = true;
        StreamSupport.stream(this.listeners).forEach(listener -> {
            try {
                listener.onBackground();
            }
            catch (Exception ex) {
                EmbraceLogger.logDebug(ERROR_FAILED_TO_NOTIFY, ex);
            }
        });
    }

    public void onTrimMemory(int trimLevel) {
        if (trimLevel == 10) {
            try {
                this.memoryService.onMemoryWarning();
            }
            catch (Exception ex) {
                EmbraceLogger.logDebug("Failed to handle onTrimMemory (low memory) event", ex);
            }
        }
    }

    public void onConfigurationChanged(Configuration configuration) {
    }

    public void onLowMemory() {
    }

    @Override
    public boolean isInBackground() {
        return this.isInBackground;
    }

    @Override
    public Optional<Activity> getForegroundActivity() {
        Optional foregroundActivity = Optional.fromNullable(this.currentActivity.get());
        if (!foregroundActivity.isPresent() || ((Activity)foregroundActivity.get()).isFinishing()) {
            return Optional.absent();
        }
        return foregroundActivity;
    }

    @Override
    public void addListener(ActivityListener listener, boolean priority) {
        if (!this.listeners.contains(listener)) {
            if (priority) {
                this.listeners.add(0, listener);
            } else {
                this.listeners.addIfAbsent(listener);
            }
        }
    }

    @Override
    public void addListener(ActivityListener listener) {
        this.addListener(listener, false);
    }

    @Override
    public void removeListener(ActivityListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public void close() {
        try {
            EmbraceLogger.logDebug("Shutting down EmbraceActivityService");
            this.application.getApplicationContext().unregisterComponentCallbacks((ComponentCallbacks)this);
            this.application.unregisterActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this);
            this.listeners.clear();
            this.appStateWorker.close();
        }
        catch (Exception ex) {
            EmbraceLogger.logDebug("Error when closing EmbraceActivityService", ex);
        }
    }
}

