package io.embrace.android.embracesdk.network.http;

import androidx.annotation.Nullable;

import java.security.cert.Certificate;

import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSocketFactory;

public interface EmbraceSslUrlConnectionService extends EmbraceUrlConnectionService {

    @Nullable
    String getCipherSuite();

    Certificate[] getLocalCertificates();

    Certificate[] getServerCertificates() throws SSLPeerUnverifiedException;

    SSLSocketFactory getSSLSocketFactory();

    void setSSLSocketFactory(SSLSocketFactory factory);

    HostnameVerifier getHostnameVerifier();

    void setHostnameVerifier(HostnameVerifier verifier);
}
