/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.embracesdk;

import com.fernandocejas.arrow.checks.Preconditions;
import com.fernandocejas.arrow.optional.Optional;
import io.embrace.android.embracesdk.ApiClient;
import io.embrace.android.embracesdk.BackgroundWorker;
import io.embrace.android.embracesdk.ConfigService;
import io.embrace.android.embracesdk.EmbraceEvent;
import io.embrace.android.embracesdk.EmbraceLogger;
import io.embrace.android.embracesdk.Event;
import io.embrace.android.embracesdk.EventMessage;
import io.embrace.android.embracesdk.MemoryCleanerListener;
import io.embrace.android.embracesdk.MemoryCleanerService;
import io.embrace.android.embracesdk.MessageType;
import io.embrace.android.embracesdk.MetadataService;
import io.embrace.android.embracesdk.ScreenshotService;
import io.embrace.android.embracesdk.Stacktraces;
import io.embrace.android.embracesdk.UserService;
import io.embrace.android.embracesdk.Uuid;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.concurrent.ConcurrentSkipListMap;

class EmbraceRemoteLogger
implements MemoryCleanerListener {
    private static final int LOG_MESSAGE_MAXIMUM_ALLOWED_LENGTH = 128;
    private final MetadataService metadataService;
    private final ScreenshotService screenshotService;
    private final ApiClient apiClient;
    private final UserService userService;
    private final ConfigService configService;
    private final BackgroundWorker worker = BackgroundWorker.ofSingleThread("Remote logging");
    private final Object lock = new Object();
    private final NavigableMap<Long, String> infoLogIds = new ConcurrentSkipListMap<Long, String>();
    private final NavigableMap<Long, String> warningLogIds = new ConcurrentSkipListMap<Long, String>();
    private final NavigableMap<Long, String> errorLogIds = new ConcurrentSkipListMap<Long, String>();
    private int maxLength;

    EmbraceRemoteLogger(MetadataService metadataService, ScreenshotService screenshotService, ApiClient apiClient, UserService userService, ConfigService configService, MemoryCleanerService memoryCleanerService) {
        this.metadataService = (MetadataService)Preconditions.checkNotNull((Object)metadataService);
        this.screenshotService = (ScreenshotService)Preconditions.checkNotNull((Object)screenshotService);
        this.apiClient = (ApiClient)Preconditions.checkNotNull((Object)apiClient);
        this.userService = (UserService)Preconditions.checkNotNull((Object)userService);
        this.configService = (ConfigService)Preconditions.checkNotNull((Object)configService);
        ((MemoryCleanerService)Preconditions.checkNotNull((Object)memoryCleanerService)).addListener(this);
        this.maxLength = configService.getConfig().getLogMessageMaximumAllowedLength().isPresent() ? (Integer)configService.getConfig().getLogMessageMaximumAllowedLength().get() : 128;
    }

    static List<String> getWrappedStackTrace() {
        return EmbraceRemoteLogger.getWrappedStackTrace(Thread.currentThread().getStackTrace());
    }

    static List<String> getWrappedStackTrace(StackTraceElement[] stackTraceElements) {
        ArrayList<String> augmentedStackReturnAddresses = new ArrayList<String>();
        for (StackTraceElement element : stackTraceElements) {
            augmentedStackReturnAddresses.add(element.toString());
        }
        return augmentedStackReturnAddresses;
    }

    void log(String message, EmbraceEvent.Type type, boolean takeScreenshot, Map<String, Object> properties) {
        this.log(message, type, takeScreenshot, false, properties, null, null);
    }

    void log(String message, EmbraceEvent.Type type, boolean takeScreenshot, boolean isException, Map<String, Object> properties, StackTraceElement[] stackTraceElements, String javascriptStacktrace) {
        long timestamp = System.currentTimeMillis();
        Stacktraces stacktraces = new Stacktraces(stackTraceElements != null ? EmbraceRemoteLogger.getWrappedStackTrace(stackTraceElements) : EmbraceRemoteLogger.getWrappedStackTrace(), javascriptStacktrace);
        this.worker.submit(() -> {
            Object object = this.lock;
            synchronized (object) {
                if (this.configService.isLogMessageDisabled(message)) {
                    EmbraceLogger.logWarning(String.format("Log message disabled. Ignoring log with message %s", message));
                    return null;
                }
                if (this.configService.isMessageTypeDisabled(MessageType.LOG)) {
                    EmbraceLogger.logWarning("Log message disabled. Ignoring all Logs.");
                    return null;
                }
                String id = Uuid.getEmbUuid();
                if (type.equals((Object)EmbraceEvent.Type.INFO_LOG)) {
                    this.infoLogIds.put(timestamp, id);
                } else if (type.equals((Object)EmbraceEvent.Type.WARNING_LOG)) {
                    this.warningLogIds.put(timestamp, id);
                } else if (type.equals((Object)EmbraceEvent.Type.ERROR_LOG)) {
                    this.errorLogIds.put(timestamp, id);
                } else {
                    EmbraceLogger.logWarning("Unknown log level " + type.toString());
                    return null;
                }
                Event.Builder builder = Event.newBuilder().withType(type).withName(this.processLogMessage(message)).withIsException(isException).withTimestamp(System.currentTimeMillis()).withAppState(this.metadataService.getAppState()).withMessageId(id).withCustomProperties(properties);
                Optional<String> optionalSessionId = this.metadataService.getActiveSessionId();
                if (optionalSessionId.isPresent()) {
                    builder.withSessionId((String)optionalSessionId.get());
                }
                if (takeScreenshot && !this.configService.isScreenshotDisabledForEvent(message)) {
                    boolean screenshotTaken = this.screenshotService.takeScreenshotLogEvent(id);
                    builder.withScreenshotTaken(screenshotTaken);
                }
                Event event = builder.build();
                EventMessage.Builder eventMessageBuilder = EventMessage.newBuilder().withEvent(event).withDeviceInfo(this.metadataService.getDeviceInfo()).withTelephonyInfo(this.metadataService.getTelephonyInfo()).withAppInfo(this.metadataService.getAppInfo()).withUserInfo(this.userService.getUserInfo()).withStacktraces(stacktraces);
                this.apiClient.sendLogs(eventMessageBuilder.build());
            }
            return null;
        });
    }

    List<String> findInfoLogIds(long startTime, long endTime) {
        return new ArrayList<String>(this.infoLogIds.subMap(startTime, endTime).values());
    }

    List<String> findWarningLogIds(long startTime, long endTime) {
        return new ArrayList<String>(this.warningLogIds.subMap(startTime, endTime).values());
    }

    List<String> findErrorLogIds(long startTime, long endTime) {
        return new ArrayList<String>(this.errorLogIds.subMap(startTime, endTime).values());
    }

    private String processLogMessage(String message) {
        if (message.length() > this.maxLength) {
            String endChars = "...";
            int allowedLength = this.maxLength >= endChars.length() ? this.maxLength - endChars.length() : 128 - endChars.length();
            EmbraceLogger.logWarning(String.format("Truncating message to %s characters", message));
            return String.format("%s%s", message.substring(0, allowedLength), endChars);
        }
        return message;
    }

    @Override
    public void cleanCollections() {
        this.infoLogIds.clear();
        this.warningLogIds.clear();
        this.errorLogIds.clear();
    }
}

