/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.embracesdk;

import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.os.Message;
import androidx.annotation.Nullable;
import com.fernandocejas.arrow.checks.Preconditions;
import io.embrace.android.embracesdk.AnrInterval;
import io.embrace.android.embracesdk.AnrService;
import io.embrace.android.embracesdk.AnrStacktraces;
import io.embrace.android.embracesdk.AnrTick;
import io.embrace.android.embracesdk.CacheService;
import io.embrace.android.embracesdk.Clock;
import io.embrace.android.embracesdk.ConfigService;
import io.embrace.android.embracesdk.Embrace;
import io.embrace.android.embracesdk.EmbraceLogger;
import io.embrace.android.embracesdk.MemoryCleanerListener;
import io.embrace.android.embracesdk.MemoryCleanerService;
import io.embrace.android.embracesdk.ThreadInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Set;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.regex.Pattern;
import java9.util.stream.StreamSupport;

final class EmbraceAnrService
implements AnrService,
MemoryCleanerListener {
    private static final String MAIN_THREAD_NAME = "main";
    private static final long ANR_THRESHOLD_INTERVAL = 1000L;
    static final int HEALTHCHECK_EXECUTE = 34592;
    static final int HEALTHCHECK_REQUEST = 34593;
    static final int HEALTHCHECK_RESPONSE = 34594;
    private final Clock clock;
    private final ConfigService configService;
    private final CacheService cacheService;
    private final NavigableMap<Long, AnrInterval> anrIntervals;
    private final MainThreadHandler mainThreadHandler;
    private final MonitoringThreadHandler monitoringThreadHandler;
    private final HandlerThread monitoringThread;
    private volatile long lastAlive;
    private volatile boolean anrInProgress;
    private final HashMap<Long, Integer> currentStacktraceStates = new HashMap();
    private AnrStacktraces stacktraces;
    private int anrTickCounter = 0;

    EmbraceAnrService(Clock clock, MemoryCleanerService memoryCleanerService, ConfigService configService, CacheService cacheService) {
        this.clock = clock;
        this.configService = (ConfigService)Preconditions.checkNotNull((Object)configService);
        this.cacheService = (CacheService)Preconditions.checkNotNull((Object)cacheService);
        this.anrIntervals = new ConcurrentSkipListMap<Long, AnrInterval>();
        this.monitoringThread = new HandlerThread("Embrace ANR Healthcheck");
        this.monitoringThread.start();
        Looper callingThreadLooper = this.monitoringThread.getLooper();
        this.monitoringThreadHandler = new MonitoringThreadHandler(callingThreadLooper);
        this.mainThreadHandler = new MainThreadHandler(Looper.getMainLooper());
        this.monitoringThreadHandler.runHealthcheck();
        ((MemoryCleanerService)Preconditions.checkNotNull((Object)memoryCleanerService)).addListener(this);
        this.stacktraces = new AnrStacktraces();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<AnrInterval> getAnrIntervals(long startTime, long endTime) {
        EmbraceAnrService embraceAnrService = this;
        synchronized (embraceAnrService) {
            Collection<AnrInterval> intervals = this.anrIntervals.subMap(startTime, endTime).values();
            ArrayList<AnrInterval> results = new ArrayList<AnrInterval>(intervals);
            if (this.anrInProgress && !this.isAnrCaptureLimitReached()) {
                AnrInterval.Builder anrIntervalBuilder = AnrInterval.newBuilder();
                anrIntervalBuilder.withStartTime(this.lastAlive).withLastKnownTime(this.clock.now()).withEndTime(null).withType(AnrInterval.Type.UI);
                if (this.configService.isAnrCaptureEnabled()) {
                    anrIntervalBuilder.withStacktraces(this.stacktraces);
                }
                results.add(anrIntervalBuilder.build());
            }
            return results;
        }
    }

    @Override
    public void close() {
        try {
            this.monitoringThread.quit();
            this.monitoringThread.join();
        }
        catch (Exception ex) {
            EmbraceLogger.logDebug("Failed to cleanly shut down EmbraceAnrService");
        }
    }

    @Override
    public void cleanCollections() {
        this.anrIntervals.clear();
    }

    private boolean isAnrCaptureLimitReached() {
        return this.anrIntervals.size() >= this.configService.getConfig().getMaxAnrCapturedIntervalsPerSession();
    }

    private void cacheStacktraces(AnrTick tick) {
        this.cacheService.cacheObject(String.format(Locale.getDefault(), "%s_%d_%d", Embrace.getInstance().getSessionService().getActiveSession().getSessionId(), this.lastAlive, this.anrTickCounter++), tick, AnrTick.class);
    }

    @Nullable
    private AnrInterval loadCachedAnrIntervals(String cacheSessionId) {
        if (this.configService.isAnrCaptureEnabled() && cacheSessionId != null && !cacheSessionId.isEmpty()) {
            List<AnrTick> cachedTicks = this.cacheService.loadObjectsByRegex(cacheSessionId, AnrTick.class);
            AnrStacktraces currentStacktraces = new AnrStacktraces();
            currentStacktraces.addAll(this.stacktraces.getTicks());
            if (!cachedTicks.isEmpty()) {
                StreamSupport.stream(cachedTicks).filter(p -> this.stacktraces.getTicks().contains(p)).forEachOrdered(currentStacktraces::add);
                currentStacktraces.addAll(cachedTicks);
                AnrInterval.Builder anrIntervalBuilder = AnrInterval.newBuilder();
                anrIntervalBuilder.withStartTime(cachedTicks.get(0).getTimestamp()).withLastKnownTime(this.clock.now()).withEndTime(null).withType(AnrInterval.Type.UI).withStacktraces(currentStacktraces);
                this.cacheService.deleteObjectsByRegex(cacheSessionId);
                return anrIntervalBuilder.build();
            }
        }
        return null;
    }

    class MainThreadHandler
    extends Handler {
        public MainThreadHandler(Looper looper) {
            super(looper);
        }

        public void handleMessage(Message msg) {
            try {
                if (msg.what == 34593) {
                    EmbraceAnrService.this.monitoringThreadHandler.sendMessage(this.obtainMessage(34594));
                }
            }
            catch (Exception ex) {
                EmbraceLogger.logDebug("ANR healthcheck failed in main (monitored) thread", ex);
            }
            super.handleMessage(msg);
        }
    }

    class MonitoringThreadHandler
    extends Handler {
        public MonitoringThreadHandler(Looper looper) {
            super(looper);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleMessage(Message msg) {
            block12: {
                try {
                    boolean anrThresholdExceeded;
                    long timestamp = EmbraceAnrService.this.clock.now();
                    boolean bl = anrThresholdExceeded = EmbraceAnrService.this.lastAlive > 0L && timestamp - EmbraceAnrService.this.lastAlive > 1000L;
                    if (msg.what == 34594) {
                        if (anrThresholdExceeded) {
                            EmbraceLogger.logDebug("Main thread recovered from not responding for > 1s");
                            EmbraceAnrService embraceAnrService = EmbraceAnrService.this;
                            synchronized (embraceAnrService) {
                                if (!EmbraceAnrService.this.isAnrCaptureLimitReached()) {
                                    AnrInterval.Builder anrIntervalBuilder = AnrInterval.newBuilder();
                                    anrIntervalBuilder.withStartTime(EmbraceAnrService.this.lastAlive).withLastKnownTime(timestamp).withEndTime(timestamp).withType(AnrInterval.Type.UI);
                                    if (EmbraceAnrService.this.configService.isAnrCaptureEnabled()) {
                                        anrIntervalBuilder.withStacktraces(EmbraceAnrService.this.stacktraces);
                                    }
                                    EmbraceAnrService.this.anrIntervals.put(timestamp, anrIntervalBuilder.build());
                                }
                                EmbraceAnrService.this.stacktraces = new AnrStacktraces();
                                EmbraceAnrService.this.anrTickCounter = 0;
                                EmbraceAnrService.this.currentStacktraceStates.clear();
                            }
                        }
                        EmbraceAnrService.this.lastAlive = timestamp;
                        EmbraceAnrService.this.anrInProgress = false;
                        break block12;
                    }
                    if (msg.what == 34592) {
                        if (anrThresholdExceeded && !EmbraceAnrService.this.anrInProgress) {
                            EmbraceLogger.logDebug("Main thread not responding for > 1s");
                            EmbraceAnrService.this.currentStacktraceStates.clear();
                            EmbraceAnrService.this.anrInProgress = true;
                        }
                        if (EmbraceAnrService.this.anrInProgress) {
                            this.processAnrTick();
                        }
                        this.runHealthcheck();
                    }
                }
                catch (Exception ex) {
                    EmbraceLogger.logDebug("ANR healthcheck failed in monitoring thread", ex);
                }
            }
        }

        void runHealthcheck() {
            EmbraceAnrService.this.mainThreadHandler.sendMessage(this.obtainMessage(34593));
            EmbraceAnrService.this.monitoringThreadHandler.sendMessageDelayed(this.obtainMessage(34592), EmbraceAnrService.this.configService.getConfig().getCaptureAnrIntervalMs());
        }

        private synchronized void processAnrTick() {
            if (!EmbraceAnrService.this.configService.isAnrCaptureEnabled()) {
                return;
            }
            if (EmbraceAnrService.this.isAnrCaptureLimitReached()) {
                EmbraceLogger.logDebug("ANR stacktrace not captured. Maximum allowed anr intervals per session reached.");
                return;
            }
            if (EmbraceAnrService.this.stacktraces.size() >= EmbraceAnrService.this.configService.getConfig().getStacktracesPerInterval()) {
                EmbraceLogger.logDebug("ANR stacktrace not captured. Maximum allowed ticks per anr interval reached.");
                return;
            }
            AnrTick anrTick = new AnrTick(EmbraceAnrService.this.clock.now());
            for (ThreadInfo threadInfo : this.getAllowedThreads()) {
                Integer threadHash = (Integer)EmbraceAnrService.this.currentStacktraceStates.get(threadInfo.getThreadId());
                if (threadHash != null) {
                    if (threadHash.intValue() == threadInfo.hashCode()) continue;
                    this.updateThread(threadInfo, anrTick);
                    continue;
                }
                this.updateThread(threadInfo, anrTick);
            }
            EmbraceAnrService.this.stacktraces.add(anrTick);
        }

        private void updateThread(ThreadInfo threadInfo, AnrTick anrTick) {
            EmbraceAnrService.this.currentStacktraceStates.put(threadInfo.getThreadId(), threadInfo.hashCode());
            anrTick.add(threadInfo);
        }

        private Set<ThreadInfo> getAllowedThreads() {
            HashSet<ThreadInfo> allowed = new HashSet<ThreadInfo>();
            List<String> blackList = EmbraceAnrService.this.configService.getConfig().getAnrBlackList();
            List<String> whiteList = EmbraceAnrService.this.configService.getConfig().getAnrWhiteList();
            int anrStacktracesMaxLength = EmbraceAnrService.this.configService.getConfig().getAnrStacktracesMaxDepth();
            int priority = EmbraceAnrService.this.configService.getConfig().getAnrThreadCapturePriority();
            for (Map.Entry<Thread, StackTraceElement[]> entry : Thread.getAllStackTraces().entrySet()) {
                ThreadInfo threadInfo = ThreadInfo.ofThread(entry.getKey(), entry.getValue(), anrStacktracesMaxLength);
                if (EmbraceAnrService.this.configService.getConfig().captureMainThreadOnly()) {
                    if (!entry.getKey().getName().equals(EmbraceAnrService.MAIN_THREAD_NAME) || !this.isAllowedByPriority(priority, threadInfo)) continue;
                    allowed.add(threadInfo);
                    break;
                }
                if (whiteList != null && !whiteList.isEmpty()) {
                    if (!this.isAllowedByList(whiteList, threadInfo) || !this.isAllowedByPriority(priority, threadInfo)) continue;
                    allowed.add(threadInfo);
                    continue;
                }
                if (blackList != null && !blackList.isEmpty()) {
                    if (this.isAllowedByList(blackList, threadInfo) || !this.isAllowedByPriority(priority, threadInfo)) continue;
                    allowed.add(threadInfo);
                    continue;
                }
                if (!this.isAllowedByPriority(priority, threadInfo)) continue;
                allowed.add(threadInfo);
            }
            return allowed;
        }

        private boolean isAllowedByList(List<String> allowed, ThreadInfo threadInfo) {
            for (String regex : allowed) {
                if (!Pattern.compile(regex).matcher(threadInfo.getName()).find()) continue;
                return true;
            }
            return false;
        }

        private boolean isAllowedByPriority(int priority, ThreadInfo threadInfo) {
            if (priority != 0) {
                return threadInfo.getPriority() >= priority;
            }
            return true;
        }
    }
}

