/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.embracesdk;

import io.embrace.android.embracesdk.network.http.HttpMethod;
import io.embrace.android.embracesdk.utils.exceptions.Unchecked;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;

final class ApiRequest {
    private final String contentType;
    private final String userAgent;
    private final String contentEncoding;
    private final String accept;
    private final String acceptEncoding;
    private final String appId;
    private final String deviceId;
    private final String eventId;
    private final String logId;
    private final URL url;
    private final HttpMethod httpMethod;

    private ApiRequest(Builder builder) {
        this.contentType = builder.contentType;
        this.userAgent = builder.userAgent;
        this.contentEncoding = builder.contentEncoding;
        this.acceptEncoding = builder.acceptEncoding;
        this.accept = builder.accept;
        this.appId = builder.appId;
        this.deviceId = builder.deviceId;
        this.eventId = builder.eventId;
        this.logId = builder.logId;
        this.url = builder.url;
        this.httpMethod = builder.httpMethod;
    }

    static Builder newBuilder() {
        return new Builder();
    }

    HttpURLConnection toConection() {
        try {
            HttpURLConnection connection = (HttpURLConnection)this.url.openConnection();
            if (this.accept != null) {
                connection.setRequestProperty("Accept", this.accept);
            }
            if (this.userAgent != null) {
                connection.setRequestProperty("User-Agent", this.userAgent);
            }
            if (this.contentType != null) {
                connection.setRequestProperty("Content-Type", this.contentType);
            }
            if (this.contentEncoding != null) {
                connection.setRequestProperty("Content-Encoding", this.contentEncoding);
            }
            if (this.acceptEncoding != null) {
                connection.setRequestProperty("Accept-Encoding", this.acceptEncoding);
            }
            if (this.appId != null) {
                connection.setRequestProperty("X-EM-AID", this.appId);
            }
            if (this.deviceId != null) {
                connection.setRequestProperty("X-EM-DID", this.deviceId);
            }
            if (this.eventId != null) {
                connection.setRequestProperty("X-EM-SID", this.eventId);
            }
            if (this.logId != null) {
                connection.setRequestProperty("X-EM-LID", this.logId);
            }
            connection.setRequestMethod(this.httpMethod.name());
            if (this.httpMethod.equals((Object)HttpMethod.POST)) {
                connection.setDoOutput(true);
            }
            return connection;
        }
        catch (IOException ex) {
            throw Unchecked.propagate(ex);
        }
    }

    static final class Builder {
        private String contentType = "application/json";
        private String userAgent = String.format("Embrace/a/%s", "4.2.9");
        private String contentEncoding;
        private String accept = "application/json";
        private String acceptEncoding;
        private String appId;
        private String deviceId;
        private String eventId;
        private String logId;
        private URL url;
        private HttpMethod httpMethod = HttpMethod.POST;

        private Builder() {
        }

        public Builder withContentType(String contentType) {
            this.contentType = contentType;
            return this;
        }

        public Builder withUserAgent(String userAgent) {
            this.userAgent = userAgent;
            return this;
        }

        public Builder withContentEncoding(String contentEncoding) {
            this.contentEncoding = contentEncoding;
            return this;
        }

        public Builder withAcceptEncoding(String acceptEncoding) {
            this.acceptEncoding = acceptEncoding;
            return this;
        }

        public Builder withAccept(String accept) {
            this.accept = accept;
            return this;
        }

        public Builder withAppId(String appId) {
            this.appId = appId;
            return this;
        }

        public Builder withDeviceId(String deviceId) {
            this.deviceId = deviceId;
            return this;
        }

        public Builder withEventId(String eventId) {
            this.eventId = eventId;
            return this;
        }

        public Builder withLogId(String logId) {
            this.logId = logId;
            return this;
        }

        public Builder withUrl(URL url) {
            this.url = url;
            return this;
        }

        public Builder withHttpMethod(HttpMethod httpMethod) {
            this.httpMethod = httpMethod;
            return this;
        }

        public ApiRequest build() {
            return new ApiRequest(this);
        }
    }
}

