package io.embrace.android.embracesdk;

import com.google.gson.annotations.SerializedName;

/**
 * Breadcrumb that represents a fragment that was viewed.
 */
class FragmentBreadcrumb implements Breadcrumb {

    @SerializedName("n")
    private final String name;

    @SerializedName("st")
    private long startTime;

    @SerializedName("en")
    private long endTime;

    @Override
    public int hashCode() {
        return name.hashCode();
    }

    FragmentBreadcrumb(String name, long startTime, long endTime) {
        this.name = name;
        this.startTime = startTime;
        this.endTime = endTime;
    }

    public String getName() {
        return name;
    }

    public long getStartTime() { return startTime; }

    public long getEndTime() { return endTime; }

    public void setStartTime(long startTime) { this.startTime = startTime; }

    public void setEndTime(long endTime) { this.endTime = endTime; }

    @Override
    public boolean equals(Object o) {
       // If the object is compared with itself then return true
        if (o == this) {
            return true;
        }

        /* Check if o is an instance of FragmentBreadcrumb or not "null instanceof [type]" also returns false */
        if (!(o instanceof FragmentBreadcrumb)) {
            return false;
        }

        FragmentBreadcrumb f = (FragmentBreadcrumb) o;

        // Compare the data members and return accordingly
        return name.equals(f.name);
    }
}
