/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.embracesdk.network.http;

import android.annotation.TargetApi;
import android.os.Build;
import io.embrace.android.embracesdk.Embrace;
import io.embrace.android.embracesdk.EmbraceLogger;
import io.embrace.android.embracesdk.network.http.CountingInputStreamWithCallback;
import io.embrace.android.embracesdk.network.http.CountingOutputStream;
import io.embrace.android.embracesdk.network.http.EmbraceHttpPathOverride;
import io.embrace.android.embracesdk.network.http.EmbraceHttpUrlConnectionOverride;
import io.embrace.android.embracesdk.network.http.HttpMethod;
import io.embrace.android.embracesdk.utils.exceptions.Unchecked;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.ProtocolException;
import java.net.URL;
import java.net.URLConnection;
import java.security.Permission;
import java.security.Principal;
import java.security.cert.Certificate;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import java9.util.function.Consumer;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSocketFactory;

public class EmbraceHttpsUrlConnection<T extends HttpsURLConnection>
extends HttpsURLConnection {
    private static final String CONTENT_ENCODING = "Content-Encoding";
    private static final String CONTENT_LENGTH = "Content-Length";
    private final T connection;
    private final long createdTime;
    private final boolean enableWrapIOStreams;
    private volatile CountingOutputStream outputStream;
    private volatile boolean didLogNetworkCall = false;
    private volatile Long endTime;
    private volatile Long startTime;
    private volatile String traceId;

    public EmbraceHttpsUrlConnection(T connection, boolean enableWrapIOStreams) {
        super(((URLConnection)connection).getURL());
        this.connection = connection;
        this.createdTime = System.currentTimeMillis();
        this.enableWrapIOStreams = enableWrapIOStreams;
    }

    @Override
    public void addRequestProperty(String key, String value) {
        ((URLConnection)this.connection).addRequestProperty(key, value);
    }

    @Override
    public void connect() throws IOException {
        this.identifyTraceId();
        ((URLConnection)this.connection).connect();
    }

    @Override
    public void disconnect() {
        this.identifyTraceId();
        this.logNetworkCall(this.createdTime);
        ((HttpURLConnection)this.connection).disconnect();
    }

    @Override
    public boolean getAllowUserInteraction() {
        return ((URLConnection)this.connection).getAllowUserInteraction();
    }

    @Override
    public void setAllowUserInteraction(boolean allowUserInteraction) {
        ((URLConnection)this.connection).setAllowUserInteraction(allowUserInteraction);
    }

    @Override
    public String getCipherSuite() {
        return ((HttpsURLConnection)this.connection).getCipherSuite();
    }

    @Override
    public int getConnectTimeout() {
        return ((URLConnection)this.connection).getConnectTimeout();
    }

    @Override
    public void setConnectTimeout(int timeout) {
        ((URLConnection)this.connection).setConnectTimeout(timeout);
    }

    @Override
    public Object getContent() throws IOException {
        this.identifyTraceId();
        return ((URLConnection)this.connection).getContent();
    }

    public Object getContent(Class[] classes) throws IOException {
        this.identifyTraceId();
        return ((URLConnection)this.connection).getContent(classes);
    }

    @Override
    public String getContentEncoding() {
        return this.shouldUncompressGzip() ? null : ((URLConnection)this.connection).getContentEncoding();
    }

    @Override
    public int getContentLength() {
        return this.shouldUncompressGzip() ? -1 : ((URLConnection)this.connection).getContentLength();
    }

    @Override
    @TargetApi(value=24)
    public long getContentLengthLong() {
        return this.shouldUncompressGzip() || Build.VERSION.SDK_INT < 24 ? -1L : ((URLConnection)this.connection).getContentLengthLong();
    }

    @Override
    public String getContentType() {
        return ((URLConnection)this.connection).getContentType();
    }

    @Override
    public long getDate() {
        return ((URLConnection)this.connection).getDate();
    }

    @Override
    public boolean getDefaultUseCaches() {
        return ((URLConnection)this.connection).getDefaultUseCaches();
    }

    @Override
    public void setDefaultUseCaches(boolean defaultUseCaches) {
        ((URLConnection)this.connection).setDefaultUseCaches(defaultUseCaches);
    }

    @Override
    public boolean getDoInput() {
        return ((URLConnection)this.connection).getDoInput();
    }

    @Override
    public void setDoInput(boolean doInput) {
        ((URLConnection)this.connection).setDoInput(doInput);
    }

    @Override
    public boolean getDoOutput() {
        return ((URLConnection)this.connection).getDoOutput();
    }

    @Override
    public void setDoOutput(boolean doOutput) {
        ((URLConnection)this.connection).setDoOutput(doOutput);
    }

    @Override
    public InputStream getErrorStream() {
        InputStream in;
        this.identifyTraceId();
        long startTime = System.currentTimeMillis();
        InputStream parentStream = this.enableWrapIOStreams && ((URLConnection)this.connection).getContentLength() < 0 ? this.countingInputStream(((HttpURLConnection)this.connection).getErrorStream()) : ((HttpURLConnection)this.connection).getErrorStream();
        if (parentStream != null) {
            if (this.shouldUncompressGzip()) {
                try {
                    in = Unchecked.wrap(() -> new GZIPInputStream(parentStream));
                }
                catch (Exception e) {
                    in = parentStream;
                }
            } else {
                in = parentStream;
            }
        } else {
            in = null;
        }
        this.logNetworkCall(startTime);
        return in;
    }

    @Override
    public long getExpiration() {
        return ((URLConnection)this.connection).getExpiration();
    }

    @Override
    public String getHeaderField(int n) {
        long startTime = System.currentTimeMillis();
        String key = ((HttpURLConnection)this.connection).getHeaderFieldKey(n);
        if (key != null && this.shouldUncompressGzip() && (key.equals(CONTENT_ENCODING) || key.equals(CONTENT_LENGTH))) {
            return null;
        }
        String headerField = ((HttpURLConnection)this.connection).getHeaderField(n);
        this.logNetworkCall(startTime);
        return headerField;
    }

    @Override
    public String getHeaderField(String name) {
        if (name == null) {
            return null;
        }
        long startTime = System.currentTimeMillis();
        if (this.shouldUncompressGzip() && (name.equals(CONTENT_ENCODING) || name.equals(CONTENT_LENGTH))) {
            return null;
        }
        String headerField = ((URLConnection)this.connection).getHeaderField(name);
        this.logNetworkCall(startTime);
        return headerField;
    }

    @Override
    public long getHeaderFieldDate(String name, long defaultValue) {
        long startTime = System.currentTimeMillis();
        if (name != null && this.shouldUncompressGzip() && (name.equals(CONTENT_ENCODING) || name.equals(CONTENT_LENGTH))) {
            return defaultValue;
        }
        long result = ((HttpURLConnection)this.connection).getHeaderFieldDate(name, defaultValue);
        this.logNetworkCall(startTime);
        return result;
    }

    @Override
    public int getHeaderFieldInt(String name, int defaultValue) {
        long startTime = System.currentTimeMillis();
        if (name != null && this.shouldUncompressGzip() && (name.equals(CONTENT_ENCODING) || name.equals(CONTENT_LENGTH))) {
            return defaultValue;
        }
        int result = ((URLConnection)this.connection).getHeaderFieldInt(name, defaultValue);
        this.logNetworkCall(startTime);
        return result;
    }

    @Override
    public String getHeaderFieldKey(int n) {
        long startTime = System.currentTimeMillis();
        String headerFieldKey = ((HttpURLConnection)this.connection).getHeaderFieldKey(n);
        if (headerFieldKey != null && this.shouldUncompressGzip() && (headerFieldKey.equals(CONTENT_ENCODING) || headerFieldKey.equals(CONTENT_LENGTH))) {
            return null;
        }
        this.logNetworkCall(startTime);
        return headerFieldKey;
    }

    @Override
    @TargetApi(value=24)
    public long getHeaderFieldLong(String name, long defaultValue) {
        long startTime = System.currentTimeMillis();
        if (name != null && this.shouldUncompressGzip() && (name.equals(CONTENT_ENCODING) || name.equals(CONTENT_LENGTH))) {
            return defaultValue;
        }
        long result = Build.VERSION.SDK_INT < 24 ? -1L : ((URLConnection)this.connection).getHeaderFieldLong(name, defaultValue);
        this.logNetworkCall(startTime);
        return result;
    }

    @Override
    public Map<String, List<String>> getHeaderFields() {
        Map<String, List<String>> copy;
        long startTime = System.currentTimeMillis();
        Map<String, List<String>> headerFields = ((URLConnection)this.connection).getHeaderFields();
        if (headerFields != null) {
            copy = new HashMap<String, List<String>>(headerFields);
            copy.remove(CONTENT_ENCODING);
            copy.remove(CONTENT_LENGTH);
        } else {
            copy = Collections.emptyMap();
        }
        this.logNetworkCall(startTime);
        return copy;
    }

    @Override
    public HostnameVerifier getHostnameVerifier() {
        return ((HttpsURLConnection)this.connection).getHostnameVerifier();
    }

    @Override
    public void setHostnameVerifier(HostnameVerifier verifier) {
        ((HttpsURLConnection)this.connection).setHostnameVerifier(verifier);
    }

    @Override
    public long getIfModifiedSince() {
        return ((URLConnection)this.connection).getIfModifiedSince();
    }

    @Override
    public void setIfModifiedSince(long ifModifiedSince) {
        ((URLConnection)this.connection).setIfModifiedSince(ifModifiedSince);
    }

    @Override
    public InputStream getInputStream() throws IOException {
        InputStream in;
        this.identifyTraceId();
        long startTime = System.currentTimeMillis();
        InputStream parentStream = this.enableWrapIOStreams && ((URLConnection)this.connection).getContentLength() < 0 ? this.countingInputStream(((URLConnection)this.connection).getInputStream()) : ((URLConnection)this.connection).getInputStream();
        if (parentStream != null) {
            if (this.shouldUncompressGzip()) {
                try {
                    in = new GZIPInputStream(parentStream);
                }
                catch (Exception e) {
                    in = parentStream;
                }
            } else {
                in = parentStream;
            }
        } else {
            in = null;
        }
        this.logNetworkCall(startTime);
        return in;
    }

    @Override
    public boolean getInstanceFollowRedirects() {
        return ((HttpURLConnection)this.connection).getInstanceFollowRedirects();
    }

    @Override
    public void setInstanceFollowRedirects(boolean followRedirects) {
        ((HttpURLConnection)this.connection).setInstanceFollowRedirects(followRedirects);
    }

    @Override
    public long getLastModified() {
        return ((URLConnection)this.connection).getLastModified();
    }

    @Override
    public Certificate[] getLocalCertificates() {
        return ((HttpsURLConnection)this.connection).getLocalCertificates();
    }

    @Override
    public Principal getLocalPrincipal() {
        return ((HttpsURLConnection)this.connection).getLocalPrincipal();
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        this.identifyTraceId();
        OutputStream out = ((URLConnection)this.connection).getOutputStream();
        if (this.enableWrapIOStreams && this.outputStream == null && out != null) {
            this.outputStream = new CountingOutputStream(out);
            return this.outputStream;
        }
        return out;
    }

    @Override
    public Principal getPeerPrincipal() throws SSLPeerUnverifiedException {
        return ((HttpsURLConnection)this.connection).getPeerPrincipal();
    }

    @Override
    public Permission getPermission() throws IOException {
        return ((HttpURLConnection)this.connection).getPermission();
    }

    @Override
    public int getReadTimeout() {
        return ((URLConnection)this.connection).getReadTimeout();
    }

    @Override
    public void setReadTimeout(int timeout) {
        ((URLConnection)this.connection).setReadTimeout(timeout);
    }

    @Override
    public String getRequestMethod() {
        return ((HttpURLConnection)this.connection).getRequestMethod();
    }

    @Override
    public void setRequestMethod(String method) throws ProtocolException {
        ((HttpURLConnection)this.connection).setRequestMethod(method);
    }

    @Override
    public Map<String, List<String>> getRequestProperties() {
        return ((URLConnection)this.connection).getRequestProperties();
    }

    @Override
    public String getRequestProperty(String key) {
        return ((URLConnection)this.connection).getRequestProperty(key);
    }

    @Override
    public int getResponseCode() throws IOException {
        this.identifyTraceId();
        long startTime = System.currentTimeMillis();
        int responseCode = ((HttpURLConnection)this.connection).getResponseCode();
        this.logNetworkCall(startTime);
        return responseCode;
    }

    @Override
    public String getResponseMessage() throws IOException {
        this.identifyTraceId();
        long startTime = System.currentTimeMillis();
        String responseMsg = ((HttpURLConnection)this.connection).getResponseMessage();
        this.logNetworkCall(startTime);
        return responseMsg;
    }

    @Override
    public Certificate[] getServerCertificates() throws SSLPeerUnverifiedException {
        return ((HttpsURLConnection)this.connection).getServerCertificates();
    }

    @Override
    public SSLSocketFactory getSSLSocketFactory() {
        return ((HttpsURLConnection)this.connection).getSSLSocketFactory();
    }

    @Override
    public void setSSLSocketFactory(SSLSocketFactory factory) {
        ((HttpsURLConnection)this.connection).setSSLSocketFactory(factory);
    }

    @Override
    public URL getURL() {
        return ((URLConnection)this.connection).getURL();
    }

    @Override
    public boolean getUseCaches() {
        return ((URLConnection)this.connection).getUseCaches();
    }

    @Override
    public void setUseCaches(boolean useCaches) {
        ((URLConnection)this.connection).setUseCaches(useCaches);
    }

    @Override
    public void setChunkedStreamingMode(int chunkLen) {
        ((HttpURLConnection)this.connection).setChunkedStreamingMode(chunkLen);
    }

    @Override
    public void setFixedLengthStreamingMode(int contentLength) {
        ((HttpURLConnection)this.connection).setFixedLengthStreamingMode(contentLength);
    }

    @Override
    @TargetApi(value=19)
    public void setFixedLengthStreamingMode(long contentLength) {
        if (Build.VERSION.SDK_INT >= 19) {
            ((HttpURLConnection)this.connection).setFixedLengthStreamingMode(contentLength);
        }
    }

    @Override
    public void setRequestProperty(String key, String value) {
        ((URLConnection)this.connection).setRequestProperty(key, value);
    }

    @Override
    public String toString() {
        return ((URLConnection)this.connection).toString();
    }

    @Override
    public boolean usingProxy() {
        return ((HttpURLConnection)this.connection).usingProxy();
    }

    synchronized void logNetworkCall(long startTime) {
        this.logNetworkCall(startTime, System.currentTimeMillis(), false, null);
    }

    synchronized void logNetworkCall(long startTime, long endTime, boolean overwrite, Long bytesIn) {
        if (!this.didLogNetworkCall || overwrite) {
            this.didLogNetworkCall = true;
            this.startTime = startTime;
            this.endTime = endTime;
            this.identifyTraceId();
            String url = EmbraceHttpPathOverride.getURLString(new EmbraceHttpUrlConnectionOverride((HttpURLConnection)this.connection));
            try {
                long bytesOut = this.outputStream == null ? 0L : Math.max(this.outputStream.getCount(), 0L);
                long contentLength = bytesIn == null ? (long)Math.max(((URLConnection)this.connection).getContentLength(), 0) : bytesIn;
                Embrace.getInstance().logNetworkCall(url, HttpMethod.fromString(this.getRequestMethod()), this.getResponseCode(), startTime, endTime, bytesOut, contentLength, this.traceId);
            }
            catch (Exception e) {
                Embrace.getInstance().logNetworkClientError(url, HttpMethod.fromString(this.getRequestMethod()), startTime, endTime, e.getClass().getCanonicalName(), e.getMessage(), this.traceId);
            }
        }
    }

    private InputStream countingInputStream(InputStream inputStream) {
        if (inputStream == null) {
            return null;
        }
        return new CountingInputStreamWithCallback(inputStream, (Consumer<Long>)((Consumer)bytes -> {
            if (this.startTime != null && this.endTime != null) {
                this.logNetworkCall(this.startTime, this.endTime, true, (Long)bytes);
            }
        }));
    }

    private boolean shouldUncompressGzip() {
        String contentEncoding = ((URLConnection)this.connection).getContentEncoding();
        return this.enableWrapIOStreams && contentEncoding != null && contentEncoding.equalsIgnoreCase("gzip");
    }

    private void identifyTraceId() {
        if (this.traceId == null) {
            try {
                this.traceId = this.getRequestProperty(Embrace.getInstance().getTraceIdHeader());
            }
            catch (Exception e) {
                EmbraceLogger.logDebug("Failed to retrieve actual trace id header. Current: " + this.traceId);
            }
        }
    }
}

