/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.embracesdk;

import android.support.annotation.Nullable;
import com.google.gson.annotations.SerializedName;
import java.util.ArrayList;
import java.util.List;
import java9.util.Lists;

class ThreadInfo {
    private final Long threadId;
    @SerializedName(value="n")
    private final String name;
    @SerializedName(value="p")
    private final Integer priority;
    @SerializedName(value="tt")
    private final List<String> lines;
    private final Thread.State state;

    ThreadInfo(long threadId, Thread.State state, String name, int priority, List<String> lines) {
        this.threadId = threadId;
        this.state = state;
        this.name = name;
        this.priority = priority;
        this.lines = Lists.copyOf(lines);
    }

    String getName() {
        return this.name;
    }

    int getPriority() {
        return this.priority;
    }

    List<String> getLines() {
        return this.lines;
    }

    public long getThreadId() {
        return this.threadId;
    }

    static ThreadInfo ofThread(Thread thread, StackTraceElement[] stackTraceElements) {
        return ThreadInfo.ofThread(thread, stackTraceElements, null);
    }

    static ThreadInfo ofThread(Thread thread, StackTraceElement[] stackTraceElements, Integer maxStacktraceSize) {
        String name = thread.getName();
        int priority = thread.getPriority();
        ArrayList<String> lines = new ArrayList<String>();
        for (StackTraceElement line : stackTraceElements) {
            String stacktrace = line.toString();
            if (maxStacktraceSize != null && maxStacktraceSize != 0 && maxStacktraceSize <= stacktrace.length()) {
                stacktrace = stacktrace.substring(0, maxStacktraceSize);
            }
            lines.add(stacktrace);
        }
        return new ThreadInfo(thread.getId(), thread.getState(), name, priority, lines);
    }

    public int hashCode() {
        int result = this.threadId != null ? this.threadId.hashCode() : 0;
        result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
        result = 31 * result + (this.priority != null ? this.priority.hashCode() : 0);
        result = 31 * result + (this.lines != null ? this.lines.hashCode() : 0);
        result = 31 * result + (this.state != null ? this.state.hashCode() : 0);
        return result;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ThreadInfo threadInfo = (ThreadInfo)o;
        if (this.threadId != null ? !this.threadId.equals(threadInfo.threadId) : threadInfo.threadId != null) {
            return false;
        }
        if (this.name != null ? !this.name.equals(threadInfo.name) : threadInfo.name != null) {
            return false;
        }
        if (this.priority != null ? !this.priority.equals(threadInfo.priority) : threadInfo.priority != null) {
            return false;
        }
        if (this.lines != null ? !this.lines.equals(threadInfo.lines) : threadInfo.lines != null) {
            return false;
        }
        return this.state != null ? this.state.equals((Object)threadInfo.state) : threadInfo.state == null;
    }
}

