/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.embracesdk;

import com.fernandocejas.arrow.optional.Optional;
import io.embrace.android.embracesdk.EmbraceLogger;
import io.embrace.android.embracesdk.PreferencesService;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

class EmbraceSessionProperties {
    private PreferencesService preferencesService;
    private Map<String, String> temporary;
    private Map<String, String> permanent;
    private static final int SESSION_PROPERTY_LIMIT = 10;
    private static final int SESSION_PROPERTY_KEY_LIMIT = 128;
    private static final int SESSION_PROPERTY_VALUE_LIMIT = 1024;

    EmbraceSessionProperties(PreferencesService preferencesService) {
        this.preferencesService = preferencesService;
        this.temporary = new HashMap<String, String>();
        Optional<Map<String, String>> existingPermanent = preferencesService.getPermanentSessionProperties();
        this.permanent = existingPermanent.isPresent() ? new HashMap<String, String>((Map)existingPermanent.get()) : new HashMap<String, String>();
    }

    private boolean haveKey(String key) {
        return this.permanent.containsKey(key) || this.temporary.containsKey(key);
    }

    private boolean isValidKey(String key) {
        if (key == null) {
            EmbraceLogger.logError("Session property key cannot be null");
            return false;
        }
        if (key.equals("")) {
            EmbraceLogger.logError("Session property key cannot be empty string");
            return false;
        }
        return true;
    }

    private boolean isValidValue(String key) {
        if (key == null) {
            EmbraceLogger.logError("Session property value cannot be null");
            return false;
        }
        return true;
    }

    private String enforceLength(String value, int maxLength) {
        if (value.length() <= maxLength) {
            return value;
        }
        String endChars = "...";
        return String.format("%s%s", value.substring(0, maxLength - endChars.length()), endChars);
    }

    synchronized boolean add(String key, String value, boolean isPermanent) {
        if (!this.isValidKey(key)) {
            return false;
        }
        key = this.enforceLength(key, 128);
        if (!this.isValidValue(value)) {
            return false;
        }
        value = this.enforceLength(value, 1024);
        if (this.size() > 10 || this.size() == 10 && !this.haveKey(key)) {
            EmbraceLogger.logError("Session property count is at its limit. Rejecting.");
            return false;
        }
        if (isPermanent) {
            this.permanent.put(key, value);
            this.temporary.remove(key);
            this.preferencesService.setPermanentSessionProperties(this.permanent);
        } else {
            if (this.permanent.remove(key) != null) {
                this.preferencesService.setPermanentSessionProperties(this.permanent);
            }
            this.temporary.put(key, value);
        }
        return true;
    }

    synchronized boolean remove(String key) {
        if (!this.isValidKey(key)) {
            return false;
        }
        key = this.enforceLength(key, 128);
        boolean existed = false;
        if (this.temporary.remove(key) != null) {
            existed = true;
        }
        if (this.permanent.remove(key) != null) {
            this.preferencesService.setPermanentSessionProperties(this.permanent);
            existed = true;
        }
        return existed;
    }

    synchronized Map<String, String> get() {
        HashMap<String, String> combined = new HashMap<String, String>();
        combined.putAll(this.permanent);
        combined.putAll(this.temporary);
        return Collections.unmodifiableMap(combined);
    }

    private int size() {
        return this.permanent.size() + this.temporary.size();
    }

    void clearTemporary() {
        this.temporary.clear();
    }
}

