package io.embrace.android.embracesdk;

/**
 * Detects whether certain known SDKs are present on the classpath, so that features can be toggled to prevent
 * conflicts.
 */
class SdkDetectionUtils {

  /**
   * Detects whether the Akamai Media Acceleration SDK is present on the classpath.
   *
   * @return true if it present, false otherwise
   */
  static boolean akamaiSdkPresent() {
    try {
      Class.forName("com.akamai.android.sdk.VocService");
      return true;
    } catch (Exception e) {
      return false;
    }
  }

  /**
   * Detects whether the CloudFlare SDK is present on the classpath.
   *
   * @return true if it present, false otherwise
   */
  static boolean cloudflareSdkPresent() {
    try {
      Class.forName("com.cloudflare.api.CFMobile");
      return true;
    } catch (Exception e) {
      return false;
    }
  }

  private SdkDetectionUtils() {
    // Restricted constructor
  }
}
