package io.embrace.android.embracesdk;

import android.support.annotation.Nullable;

import com.google.gson.annotations.SerializedName;

import java.util.ArrayList;
import java.util.List;

class AnrTick {

    @SerializedName("ts")
    private final Long timestamp;

    private final List<ThreadInfo> threads = new ArrayList<>();

    public AnrTick(long timestamp) {
        this.timestamp = timestamp;
    }

    public boolean isEmpty() {
        return threads.isEmpty();
    }

    public long getTimestamp() {
        return timestamp;
    }

    public void add(ThreadInfo threadInfo) {
        if (threadInfo != null) {
            threads.add(threadInfo);
        }
    }

    @Override
    public int hashCode() {
        int result = timestamp.hashCode();
        result = 31 * result + threads.hashCode();
        return result;
    }

    @Override
    public boolean equals(@Nullable Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        AnrTick anrTick = (AnrTick) o;

        if (!timestamp.equals(anrTick.timestamp)) {
            return false;
        }
        return threads.equals(anrTick.threads);
    }
}
