/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.embracesdk;

import android.content.Context;
import android.content.res.Resources;
import android.util.Base64;
import com.fernandocejas.arrow.optional.Optional;
import com.google.gson.Gson;
import com.google.gson.annotations.SerializedName;
import io.embrace.android.embracesdk.EmbraceLogger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

final class LocalConfig {
    private static final String BUILD_INFO_APP_ID = "emb_app_id";
    private static final String BUILD_INFO_SDK_CONFIG = "emb_sdk_config";
    private final String appId;
    private final SdkConfigs configs;

    private LocalConfig(String appId, SdkConfigs configs) {
        this.appId = appId;
        this.configs = (SdkConfigs)Optional.fromNullable((Object)configs).orNull();
    }

    String getAppId() {
        return this.appId;
    }

    public SdkConfigs getConfigurations() {
        return this.configs;
    }

    static LocalConfig fromResources(Context context) {
        try {
            String appId = context.getResources().getString(LocalConfig.getResourcesIdentifier(context, BUILD_INFO_APP_ID, "string"));
            String sdkConfigJson = null;
            int sdkConfigJsonId = LocalConfig.getResourcesIdentifier(context, BUILD_INFO_SDK_CONFIG, "string");
            if (sdkConfigJsonId != 0) {
                String encodedConfig = context.getResources().getString(sdkConfigJsonId);
                sdkConfigJson = new String(Base64.decode((String)encodedConfig, (int)0));
            }
            return LocalConfig.buildConfig(appId, sdkConfigJson);
        }
        catch (Exception ex) {
            throw new RuntimeException("Failed to load local config from resources.", ex);
        }
    }

    static LocalConfig buildConfig(String appId, String sdkConfigs) {
        if (appId == null || appId.isEmpty()) {
            throw new IllegalArgumentException("Embrace AppId cannot be null or empty.");
        }
        SdkConfigs configs = sdkConfigs != null && !sdkConfigs.isEmpty() ? (SdkConfigs)new Gson().fromJson(sdkConfigs, SdkConfigs.class) : new SdkConfigs();
        List<String> nonDefaultValues = configs.getNonDefaultValues();
        for (String nonDefaultValue : nonDefaultValues) {
            EmbraceLogger.logInfo("Custom config value " + nonDefaultValue);
        }
        return new LocalConfig(appId, configs);
    }

    private static int getResourcesIdentifier(Context context, String configProperty, String type) {
        Resources resources = context.getResources();
        return resources.getIdentifier(configProperty, type, context.getPackageName());
    }

    static class SdkConfigs {
        @SerializedName(value="base_urls")
        private final BaseUrls baseUrls;
        @SerializedName(value="crash_handler")
        private final CrashHandler crashHandler;
        @SerializedName(value="startup_moment")
        private final StartupMoment startupMoment;
        @SerializedName(value="networking")
        private final Networking networking;
        @SerializedName(value="session")
        private final SessionConfig sessionConfig;
        @SerializedName(value="taps")
        private final Taps taps;

        SdkConfigs() {
            this(null, null, null, null, null, null);
        }

        SdkConfigs(BaseUrls baseUrls, CrashHandler crashHandler, StartupMoment startupMoment, Networking networking, SessionConfig sessionConfig, Taps taps) {
            this.baseUrls = (BaseUrls)Optional.fromNullable((Object)baseUrls).or((Object)new BaseUrls());
            this.crashHandler = (CrashHandler)Optional.fromNullable((Object)crashHandler).or((Object)new CrashHandler());
            this.startupMoment = (StartupMoment)Optional.fromNullable((Object)startupMoment).or((Object)new StartupMoment());
            this.networking = (Networking)Optional.fromNullable((Object)networking).or((Object)new Networking());
            this.sessionConfig = (SessionConfig)Optional.fromNullable((Object)sessionConfig).or((Object)new SessionConfig());
            this.taps = (Taps)Optional.fromNullable((Object)taps).or((Object)new Taps());
        }

        BaseUrls getBaseUrls() {
            return this.baseUrls;
        }

        CrashHandler getCrashHandler() {
            return this.crashHandler;
        }

        StartupMoment getStartupMoment() {
            return this.startupMoment;
        }

        Networking getNetworking() {
            return this.networking;
        }

        SessionConfig getSessionConfig() {
            return this.sessionConfig;
        }

        Taps getTaps() {
            return this.taps;
        }

        List<String> getNonDefaultValues() {
            ArrayList<String> nonDefaultValues = new ArrayList<String>();
            List<ConfigElement> elements = Arrays.asList(this.baseUrls, this.crashHandler, this.networking, this.sessionConfig, this.startupMoment, this.taps);
            for (ConfigElement element : elements) {
                if (element.getNonDefaultValues().isEmpty()) continue;
                nonDefaultValues.addAll(element.getNonDefaultValues());
            }
            return nonDefaultValues;
        }

        static class Taps
        implements ConfigElement {
            static final Boolean CAPTURE_COORDINATES_DEFAULT = true;
            @SerializedName(value="capture_coordinates")
            private Boolean captureCoordinates;

            Taps() {
                this(null);
            }

            Taps(Boolean captureCoordinates) {
                this.captureCoordinates = (Boolean)Optional.fromNullable((Object)captureCoordinates).or((Object)CAPTURE_COORDINATES_DEFAULT);
            }

            Boolean getCaptureCoordinates() {
                return this.captureCoordinates;
            }

            @Override
            public List<String> getNonDefaultValues() {
                ArrayList<String> nonDefaultValues = new ArrayList<String>();
                if (!this.captureCoordinates.equals(CAPTURE_COORDINATES_DEFAULT)) {
                    nonDefaultValues.add("taps.capture_coordinates: " + this.captureCoordinates);
                }
                return nonDefaultValues;
            }
        }

        static class SessionConfig
        implements ConfigElement {
            private static final int DEFAULT_MINIMUM_SESSION_SECONDS = 60;
            @SerializedName(value="max_session_seconds")
            private Integer maxSessionSeconds;

            SessionConfig() {
                this(null);
            }

            SessionConfig(Integer maxSessionSeconds) {
                this.maxSessionSeconds = maxSessionSeconds;
            }

            Optional<Integer> getMaxSessionSeconds() {
                if (this.maxSessionSeconds != null) {
                    if (this.maxSessionSeconds >= 60) {
                        return Optional.of((Object)this.maxSessionSeconds);
                    }
                    EmbraceLogger.logWarning("Automatic end session disabled. Config max_session_seconds should be more than 60 seconds.");
                    return Optional.absent();
                }
                return Optional.absent();
            }

            @Override
            public List<String> getNonDefaultValues() {
                ArrayList<String> nonDefaultValues = new ArrayList<String>();
                if (this.maxSessionSeconds != null) {
                    nonDefaultValues.add("session.max_session_seconds: " + this.maxSessionSeconds);
                }
                return nonDefaultValues;
            }
        }

        static class Networking
        implements ConfigElement {
            static final String CONFIG_TRACE_ID_HEADER_DEFAULT_VALUE = "x-emb-trace-id";
            static final Boolean CAPTURE_REQUEST_CONTENT_LENGTH = true;
            @SerializedName(value="trace_id_header")
            private String traceIdHeader;
            @SerializedName(value="default_capture_limit")
            private final Integer defaultCaptureLimit;
            @SerializedName(value="domains")
            private final List<Domain> domains;
            @SerializedName(value="capture_request_content_length")
            private Boolean captureRequestContentLength;

            Networking() {
                this(null, null, null, null);
            }

            Networking(String traceIdHeader, Integer defaultCaptureLimit, List<Domain> domains, Boolean captureRequestContentLength) {
                this.traceIdHeader = (String)Optional.fromNullable((Object)traceIdHeader).or((Object)CONFIG_TRACE_ID_HEADER_DEFAULT_VALUE);
                this.defaultCaptureLimit = defaultCaptureLimit;
                this.domains = domains;
                this.captureRequestContentLength = (Boolean)Optional.fromNullable((Object)captureRequestContentLength).or((Object)CAPTURE_REQUEST_CONTENT_LENGTH);
            }

            String getTraceIdHeader() {
                return this.traceIdHeader;
            }

            Boolean getCaptureRequestContentLength() {
                return this.captureRequestContentLength;
            }

            public Optional<Integer> getDefaultCaptureLimit() {
                return Optional.fromNullable((Object)this.defaultCaptureLimit);
            }

            public List<Domain> getDomains() {
                return this.domains != null ? this.domains : Collections.emptyList();
            }

            @Override
            public List<String> getNonDefaultValues() {
                ArrayList<String> nonDefaultValues = new ArrayList<String>();
                if (!this.traceIdHeader.equals(CONFIG_TRACE_ID_HEADER_DEFAULT_VALUE)) {
                    nonDefaultValues.add("networking.trace_id_header: " + this.traceIdHeader);
                }
                if (!this.captureRequestContentLength.equals(CAPTURE_REQUEST_CONTENT_LENGTH)) {
                    nonDefaultValues.add("networking.capture_request_content_length: " + this.captureRequestContentLength);
                }
                return nonDefaultValues;
            }

            class Domain {
                @SerializedName(value="domain_name")
                private final String domain;
                @SerializedName(value="domain_limit")
                private final Integer limit;

                Domain(String domain, Integer limit) {
                    this.domain = domain;
                    this.limit = limit;
                }

                public String getDomain() {
                    return this.domain;
                }

                public Integer getLimit() {
                    return this.limit;
                }
            }
        }

        static class StartupMoment
        implements ConfigElement {
            static final Boolean AUTOMATICALLY_END_DEFAULT = true;
            static final Boolean TAKE_SCREENSHOT_DEFAULT = true;
            @SerializedName(value="automatically_end")
            private Boolean automaticallyEnd;
            @SerializedName(value="take_screenshot")
            private Boolean takeScreenshot;

            StartupMoment() {
                this(null, null);
            }

            StartupMoment(Boolean automaticallyEnd, Boolean takeScreenshot) {
                this.automaticallyEnd = (Boolean)Optional.fromNullable((Object)automaticallyEnd).or((Object)AUTOMATICALLY_END_DEFAULT);
                this.takeScreenshot = (Boolean)Optional.fromNullable((Object)takeScreenshot).or((Object)TAKE_SCREENSHOT_DEFAULT);
            }

            Boolean getAutomaticallyEnd() {
                return this.automaticallyEnd;
            }

            Boolean getTakeScreenshot() {
                return this.takeScreenshot;
            }

            @Override
            public List<String> getNonDefaultValues() {
                ArrayList<String> nonDefaultValues = new ArrayList<String>();
                if (!this.automaticallyEnd.equals(AUTOMATICALLY_END_DEFAULT)) {
                    nonDefaultValues.add("startup_moment.automatically_end: " + this.automaticallyEnd);
                }
                if (!this.takeScreenshot.equals(TAKE_SCREENSHOT_DEFAULT)) {
                    nonDefaultValues.add("startup_moment.take_screenshot: " + this.takeScreenshot);
                }
                return nonDefaultValues;
            }
        }

        static class CrashHandler
        implements ConfigElement {
            static final Boolean ENABLED_DEFAULT = true;
            @SerializedName(value="enabled")
            private Boolean enabled;

            CrashHandler() {
                this(null);
            }

            CrashHandler(Boolean enabled) {
                this.enabled = (Boolean)Optional.fromNullable((Object)enabled).or((Object)ENABLED_DEFAULT);
            }

            Boolean getEnabled() {
                return this.enabled;
            }

            @Override
            public List<String> getNonDefaultValues() {
                ArrayList<String> nonDefaultValues = new ArrayList<String>();
                if (!this.enabled.equals(ENABLED_DEFAULT)) {
                    nonDefaultValues.add("crash_handler.enabled: " + this.enabled);
                }
                return nonDefaultValues;
            }
        }

        static class BaseUrls
        implements ConfigElement {
            static final String CONFIG_DEFAULT = "https://config.emb-api.com";
            static final String DATA_DEFAULT = "https://data.emb-api.com";
            static final String DATA_DEV_DEFAULT = "https://data-dev.emb-api.com";
            static final String IMAGES_DEFAULT = "https://images.emb-api.com";
            @SerializedName(value="data")
            private String data;
            @SerializedName(value="data_dev")
            private String dataDev;
            @SerializedName(value="config")
            private String config;
            @SerializedName(value="images")
            private String images;

            BaseUrls() {
                this(null, null, null, null);
            }

            BaseUrls(String config, String data, String dataDev, String images) {
                this.config = (String)Optional.fromNullable((Object)config).or((Object)CONFIG_DEFAULT);
                this.data = (String)Optional.fromNullable((Object)data).or((Object)DATA_DEFAULT);
                this.dataDev = (String)Optional.fromNullable((Object)dataDev).or((Object)DATA_DEV_DEFAULT);
                this.images = (String)Optional.fromNullable((Object)images).or((Object)IMAGES_DEFAULT);
            }

            String getConfig() {
                return this.config;
            }

            String getData() {
                return this.data;
            }

            String getDataDev() {
                return this.dataDev;
            }

            String getImages() {
                return this.images;
            }

            @Override
            public List<String> getNonDefaultValues() {
                ArrayList<String> nonDefaultValues = new ArrayList<String>();
                if (!this.config.equals(CONFIG_DEFAULT)) {
                    nonDefaultValues.add("base_urls.config: " + this.config);
                }
                if (!this.data.equals(DATA_DEFAULT)) {
                    nonDefaultValues.add("base_urls.data: " + this.data);
                }
                if (!this.dataDev.equals(DATA_DEV_DEFAULT)) {
                    nonDefaultValues.add("base_urls.data_dev: " + this.dataDev);
                }
                if (!this.images.equals(IMAGES_DEFAULT)) {
                    nonDefaultValues.add("base_urls.images: " + this.images);
                }
                return nonDefaultValues;
            }
        }

        static interface ConfigElement {
            public List<String> getNonDefaultValues();
        }
    }
}

