/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.embracesdk;

import com.google.gson.annotations.SerializedName;
import java.util.ArrayList;
import java.util.List;
import java9.util.Lists;

class ThreadInfo {
    @SerializedName(value="n")
    private final String name;
    @SerializedName(value="p")
    private final int priority;
    @SerializedName(value="tt")
    private final List<String> lines;

    ThreadInfo(String name, int priority, List<String> lines) {
        this.name = name;
        this.priority = priority;
        this.lines = Lists.copyOf(lines);
    }

    String getName() {
        return this.name;
    }

    int getPriority() {
        return this.priority;
    }

    List<String> getLines() {
        return this.lines;
    }

    static ThreadInfo ofThread(Thread thread, StackTraceElement[] stackTraceElements) {
        String name = thread.getName();
        int priority = thread.getPriority();
        ArrayList<String> lines = new ArrayList<String>();
        for (StackTraceElement line : stackTraceElements) {
            lines.add(line.toString());
        }
        return new ThreadInfo(name, priority, lines);
    }
}

